/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleExecutionEditor;
import com.intellij.execution.console.ConsoleHistoryCopyHandler;
import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageConsoleImpl
extends ConsoleViewImpl
implements LanguageConsoleView,
DataProvider {
    private final Helper myHelper;
    private final ConsoleExecutionEditor myConsoleExecutionEditor;
    private final EditorEx myHistoryViewer;
    private final JPanel myPanel = new JPanel((LayoutManager)((Object)new MyLayout()));
    private final JScrollBar myScrollBar = new JBScrollBar(0);
    private final DocumentListener myDocumentAdapter = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent event) {
            LanguageConsoleImpl.this.myPanel.revalidate();
        }
    };

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language) {
        this(new Helper(project, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)"")));
    }

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile virtualFile) {
        this(new Helper(project, virtualFile).setTitle(title));
    }

    public LanguageConsoleImpl(@NotNull Helper helper) {
        super(helper.project, GlobalSearchScope.allScope((Project)helper.project), true, true);
        this.myHelper = helper;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myConsoleExecutionEditor = new ConsoleExecutionEditor(helper);
        Disposer.register((Disposable)this, (Disposable)this.myConsoleExecutionEditor);
        Document historyDocument = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)historyDocument);
        this.myHistoryViewer = (EditorEx)editorFactory.createViewer(historyDocument, this.getProject(), EditorKind.CONSOLE);
        this.myHistoryViewer.getDocument().addDocumentListener(this.myDocumentAdapter);
        this.myConsoleExecutionEditor.getDocument().addDocumentListener(this.myDocumentAdapter);
        this.myScrollBar.setModel(new MyModel(this.myScrollBar, this.myHistoryViewer, this.myConsoleExecutionEditor.getEditor()));
        this.myScrollBar.putClientProperty(JBScrollPane.Alignment.class, JBScrollPane.Alignment.BOTTOM);
    }

    @Override
    @NotNull
    protected final EditorEx doCreateConsoleEditor() {
        return this.myHistoryViewer;
    }

    @Override
    protected final void disposeEditor() {
    }

    @Override
    @NotNull
    protected JComponent createCenterComponent() {
        this.initComponents();
        return this.myPanel;
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleEditor().getContentComponent();
    }

    private void initComponents() {
        this.setupComponents();
        this.myPanel.add(this.myHistoryViewer.getComponent());
        this.myPanel.add(this.myConsoleExecutionEditor.getComponent());
        this.myPanel.add(this.myScrollBar);
        this.myPanel.setBackground(this.myConsoleExecutionEditor.getEditor().getBackgroundColor());
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)this);
    }

    @Override
    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        this.myConsoleExecutionEditor.setConsoleEditorEnabled(consoleEditorEnabled);
        this.setHistoryScrollBarVisible(!consoleEditorEnabled);
        this.myScrollBar.setVisible(consoleEditorEnabled);
    }

    private void setHistoryScrollBarVisible(boolean visible) {
        JScrollBar prev = this.myHistoryViewer.getScrollPane().getHorizontalScrollBar();
        prev.setEnabled(visible);
    }

    private void setupComponents() {
        this.myHelper.setupEditor(this.myConsoleExecutionEditor.getEditor());
        this.myHelper.setupEditor(this.myHistoryViewer);
        this.myHistoryViewer.getComponent().setMinimumSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.getComponent().setPreferredSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleExecutionEditor.initComponent();
        this.setHistoryScrollBarVisible(false);
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled() && UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)LanguageConsoleImpl.this.myConsoleExecutionEditor.getEditor().getContentComponent(), true));
                    LanguageConsoleImpl.this.myConsoleExecutionEditor.getEditor().processKeyTyped(event);
                }
            }
        });
        EmptyAction.registerActionShortcuts((JComponent)this.myHistoryViewer.getComponent(), (JComponent)this.myConsoleExecutionEditor.getComponent());
    }

    @Override
    public final boolean isConsoleEditorEnabled() {
        return this.myConsoleExecutionEditor.isConsoleEditorEnabled();
    }

    @Override
    @Nullable
    public String getPrompt() {
        return this.myConsoleExecutionEditor.getPrompt();
    }

    @Override
    @Nullable
    public ConsoleViewContentType getPromptAttributes() {
        return this.myConsoleExecutionEditor.getPromptAttributes();
    }

    @NotNull
    public ConsolePromptDecorator getConsolePromptDecorator() {
        return this.myConsoleExecutionEditor.getConsolePromptDecorator();
    }

    @Override
    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        this.myConsoleExecutionEditor.setPromptAttributes(textAttributes);
    }

    @Override
    public void setPrompt(@Nullable String prompt) {
        this.myConsoleExecutionEditor.setPrompt(prompt);
    }

    @Override
    public void setEditable(boolean editable) {
        this.myConsoleExecutionEditor.setEditable(editable);
    }

    @Override
    public boolean isEditable() {
        return this.myConsoleExecutionEditor.isEditable();
    }

    @Override
    @NotNull
    public final PsiFile getFile() {
        return this.myHelper.getFileSafe();
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.myConsoleExecutionEditor.getVirtualFile();
    }

    @Override
    @NotNull
    public final EditorEx getHistoryViewer() {
        return this.myHistoryViewer;
    }

    @Override
    @NotNull
    public final Document getEditorDocument() {
        return this.myConsoleExecutionEditor.getDocument();
    }

    @Override
    @NotNull
    public final EditorEx getConsoleEditor() {
        return this.myConsoleExecutionEditor.getEditor();
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.myHelper.title;
    }

    @Override
    public void setTitle(@NotNull String title) {
        this.myHelper.setTitle(title);
    }

    public String addToHistory(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean preserveMarkup) {
        return this.addToHistoryInner(textRange, editor, false, preserveMarkup);
    }

    @NotNull
    public String prepareExecuteAction(boolean addToHistory, boolean preserveMarkup, boolean clearInput) {
        EditorEx editor = this.getCurrentEditor();
        DocumentEx document = editor.getDocument();
        String text = document.getText();
        TextRange range2 = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range2, editor, clearInput, preserveMarkup);
        } else if (clearInput) {
            this.setInputText("");
        }
        return text;
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result2 = this.addTextRangeToHistory(textRange, editor, preserveMarkup);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset()));
        }
        this.scrollToEnd();
        return result2;
    }

    public static String printWithHighlighting(@NotNull LanguageConsoleView console, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        String text;
        EditorHighlighter highlighter;
        if (inputEditor instanceof EditorWindow) {
            PsiFile file2 = ((EditorWindow)inputEditor).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)console.getProject());
            String fullText = InjectedLanguageUtil.getUnescapedText(file2, null, null);
            highlighter.setText((CharSequence)fullText);
            text = textRange.substring(fullText);
        } else {
            text = inputEditor.getDocument().getText(textRange);
            highlighter = ((EditorEx)inputEditor).getHighlighter();
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        LanguageConsoleImpl consoleImpl = (LanguageConsoleImpl)console;
        consoleImpl.doAddPromptToHistory();
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, syntax, () -> {
                String identPrompt = consoleImpl.myConsoleExecutionEditor.getConsolePromptDecorator().getIndentPrompt();
                if (StringUtil.isNotEmpty((String)identPrompt)) {
                    consoleImpl.addPromptToHistoryImpl(identPrompt);
                }
            });
        } else {
            console.print(text, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        return text;
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        return LanguageConsoleImpl.printWithHighlighting(this, inputEditor, textRange);
    }

    protected void doAddPromptToHistory() {
        String prompt = this.myConsoleExecutionEditor.getPrompt();
        if (prompt != null) {
            this.addPromptToHistoryImpl(prompt);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myHistoryViewer.isDisposed()) {
            return;
        }
        this.myConsoleExecutionEditor.getDocument().removeDocumentListener(this.myDocumentAdapter);
        this.myHistoryViewer.getDocument().removeDocumentListener(this.myDocumentAdapter);
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        this.closeFile();
    }

    protected void closeFile() {
        FileEditorManager editorManager;
        if (this.getProject().isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.getVirtualFile())) {
            editorManager.closeFile(this.getVirtualFile());
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public EditorEx getCurrentEditor() {
        return this.myConsoleExecutionEditor.getCurrentEditor();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.getFile().getLanguage();
    }

    @Override
    public void setLanguage(@NotNull Language language) {
        this.myHelper.setLanguage(language);
        this.myHelper.getFileSafe();
    }

    @Override
    public void setInputText(@NotNull String query) {
        this.myConsoleExecutionEditor.setInputText(query);
    }

    boolean isHistoryViewerForceAdditionalColumnsUsage() {
        return true;
    }

    int getMinHistoryLineCount() {
        return 2;
    }

    private void addPromptToHistoryImpl(@NotNull String prompt) {
        DocumentEx document = this.getHistoryViewer().getDocument();
        RangeHighlighter highlighter = this.getHistoryViewer().getMarkupModel().addRangeHighlighter(null, document.getTextLength(), document.getTextLength(), 0, HighlighterTargetArea.EXACT_RANGE);
        this.print(prompt, this.myConsoleExecutionEditor.getPromptAttributes());
        highlighter.putUserData(ConsoleHistoryCopyHandler.PROMPT_LENGTH_MARKER, (Object)prompt.length());
    }

    private static final class MyModel
    extends DefaultBoundedRangeModel {
        private volatile boolean myInternalChange;
        private final JScrollBar myBar;
        private final EditorEx myFirstEditor;
        private final EditorEx mySecondEditor;
        private int myFirstValue;
        private int mySecondValue;

        private MyModel(JScrollBar bar, EditorEx first, EditorEx second) {
            this.myBar = bar;
            this.myFirstEditor = first;
            this.mySecondEditor = second;
            this.addChangeListener(event -> this.onChange());
            first.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
            second.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
        }

        private boolean isInternal() {
            return this.myInternalChange || !this.myFirstEditor.getComponent().isVisible() || !this.mySecondEditor.getComponent().isVisible();
        }

        private void onChange() {
            if (this.isInternal()) {
                return;
            }
            this.myInternalChange = true;
            MyModel.setValue(this.myFirstEditor.getScrollPane().getViewport(), this.getValue());
            MyModel.setValue(this.mySecondEditor.getScrollPane().getViewport(), this.getValue());
            this.myInternalChange = false;
        }

        private void onUpdate(Object source) {
            Point position;
            if (this.isInternal()) {
                return;
            }
            JViewport first = this.myFirstEditor.getScrollPane().getViewport();
            JViewport second = this.mySecondEditor.getScrollPane().getViewport();
            int value2 = this.getValue();
            if (source == first) {
                position = first.getViewPosition();
                if (position.x != this.myFirstValue) {
                    this.myFirstValue = value2 = position.x;
                }
            } else {
                position = second.getViewPosition();
                if (position.x != this.mySecondValue) {
                    this.mySecondValue = value2 = position.x;
                }
            }
            int ext = Math.min(first.getExtentSize().width, second.getExtentSize().width);
            int max = Math.max(first.getViewSize().width, second.getViewSize().width);
            this.setRangeProperties(value2, ext, 0, max, false);
            this.myBar.setEnabled(ext < max);
        }

        private static void setValue(JViewport viewport, int value2) {
            Point position = viewport.getViewPosition();
            position.x = Math.max(0, Math.min(value2, viewport.getViewSize().width - viewport.getExtentSize().width));
            viewport.setViewPosition(position);
        }
    }

    private class MyLayout
    extends AbstractLayoutManager {
        private MyLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public void layoutContainer(@NotNull Container parent) {
            EditorEx input;
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            EditorEx history = LanguageConsoleImpl.this.myHistoryViewer;
            EditorEx editorEx = input = LanguageConsoleImpl.this.isConsoleEditorEnabled() ? LanguageConsoleImpl.this.myConsoleExecutionEditor.getEditor() : null;
            if (input == null) {
                parent.getComponent(0).setBounds(parent.getBounds());
                return;
            }
            Dimension panelSize = parent.getSize();
            if (LanguageConsoleImpl.this.myScrollBar.isVisible()) {
                Dimension size = LanguageConsoleImpl.this.myScrollBar.getPreferredSize();
                if (panelSize.height < size.height) {
                    return;
                }
                panelSize.height -= size.height;
                LanguageConsoleImpl.this.myScrollBar.setBounds(0, panelSize.height, panelSize.width, size.height);
            }
            if (panelSize.getHeight() <= 0.0) {
                return;
            }
            Dimension historySize = history.getContentSize();
            Dimension inputSize = input.getContentSize();
            if (LanguageConsoleImpl.this.isHistoryViewerForceAdditionalColumnsUsage()) {
                history.getSoftWrapModel().forceAdditionalColumnsUsage();
                int minAdditionalColumns = 2;
                int historySpaceWidth = EditorUtil.getPlainSpaceWidth(history);
                historySize.width += historySpaceWidth * (minAdditionalColumns - history.getSettings().getAdditionalColumnsCount());
                int inputSpaceWidth = EditorUtil.getPlainSpaceWidth(input);
                inputSize.width += inputSpaceWidth * (minAdditionalColumns - input.getSettings().getAdditionalColumnsCount());
                int max = Math.max(historySize.width, inputSize.width);
                history.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - historySize.width) / historySpaceWidth);
                input.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - inputSize.width) / inputSpaceWidth);
            }
            if (history.getDocument().getLineCount() == 0) {
                historySize.height = 0;
            }
            int minHistoryHeight = historySize.height > 0 ? LanguageConsoleImpl.this.getMinHistoryLineCount() * history.getLineHeight() : 0;
            int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
            int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
            int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
            int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
            int oldHistoryHeight = history.getComponent().getHeight();
            int newHistoryHeight = panelSize.height - newInputHeight;
            int delta = newHistoryHeight - newHistoryHeight / history.getLineHeight() * history.getLineHeight();
            input.getComponent().setBounds(0, newHistoryHeight -= delta, panelSize.width, newInputHeight += delta);
            history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
            input.getComponent().doLayout();
            history.getComponent().doLayout();
            if (newHistoryHeight < oldHistoryHeight) {
                JViewport viewport = history.getScrollPane().getViewport();
                Point position = viewport.getViewPosition();
                position.translate(0, oldHistoryHeight - newHistoryHeight);
                viewport.setViewPosition(position);
            }
        }
    }

    public static class Helper {
        public final Project project;
        public final VirtualFile virtualFile;
        String title;
        PsiFile file;

        public Helper(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            this.project = project;
            this.virtualFile = virtualFile;
            this.title = virtualFile.getName();
        }

        public String getTitle() {
            return this.title;
        }

        public Helper setTitle(String title) {
            this.title = title;
            return this;
        }

        @NotNull
        public PsiFile getFile() {
            return (PsiFile)ReadAction.compute(() -> PsiUtilCore.getPsiFile((Project)this.project, (VirtualFile)this.virtualFile));
        }

        @NotNull
        public Document getDocument() {
            Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
            if (document == null) {
                Language language = this.virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)this.virtualFile).getLanguage() : null;
                throw new AssertionError((Object)String.format("no document for: %s (fileType: %s, language: %s, length: %s, valid: %s)", this.virtualFile, this.virtualFile.getFileType(), language, this.virtualFile.getLength(), this.virtualFile.isValid()));
            }
            return document;
        }

        public void setLanguage(Language language) {
            if (!(this.virtualFile instanceof LightVirtualFile)) {
                throw new UnsupportedOperationException();
            }
            ((LightVirtualFile)this.virtualFile).setLanguage(language);
            ((LightVirtualFile)this.virtualFile).setContent((Object)this.getDocument(), (CharSequence)this.getDocument().getText(), false);
            FileContentUtil.reparseFiles((Project)this.project, Collections.singletonList(this.virtualFile), (boolean)false);
        }

        public void setupEditor(@NotNull EditorEx editor) {
            ConsoleViewUtil.setupConsoleEditor(editor, false, false);
            editor.getContentComponent().setFocusCycleRoot(false);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.setBorder(null);
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setAdditionalLinesCount(1);
            editorSettings.setAdditionalColumnsCount(1);
            DataManager.registerDataProvider((JComponent)editor.getComponent(), dataId -> this.getEditorData(editor, dataId));
        }

        @NotNull
        public PsiFile getFileSafe() {
            return this.file == null || !this.file.isValid() ? (this.file = this.getFile()) : this.file;
        }

        @Nullable
        protected Object getEditorData(@NotNull EditorEx editor, String dataId) {
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return editor;
            }
            if (this.project.isInitialized()) {
                Caret caret = editor.getCaretModel().getCurrentCaret();
                return FileEditorManagerEx.getInstanceEx(this.project).getData(dataId, editor, caret);
            }
            return null;
        }
    }
}

