/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleExecutionEditor
implements Disposable {
    private final EditorEx myConsoleEditor;
    private EditorEx myCurrentEditor;
    private final Document myEditorDocument;
    private final LanguageConsoleImpl.Helper myHelper;
    private final MessageBusConnection myBusConnection;
    private final ConsolePromptDecorator myConsolePromptDecorator;
    private final FocusChangeListener myFocusListener = new FocusChangeListener(){

        @Override
        public void focusGained(@NotNull Editor editor) {
            ConsoleExecutionEditor.this.myCurrentEditor = (EditorEx)editor;
            if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
                ApplicationManager.getApplication().invokeLater(() -> FileDocumentManager.getInstance().saveAllDocuments());
            }
        }

        @Override
        public void focusLost(@NotNull Editor editor) {
        }
    };

    public ConsoleExecutionEditor(@NotNull LanguageConsoleImpl.Helper helper) {
        this.myHelper = helper;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myEditorDocument = helper.getDocument();
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, helper.project);
        this.myConsoleEditor.getScrollPane().getHorizontalScrollBar().setEnabled(false);
        this.myConsoleEditor.addFocusListener(this.myFocusListener);
        this.myConsoleEditor.getSettings().setVirtualSpace(false);
        this.myCurrentEditor = this.myConsoleEditor;
        this.myConsoleEditor.putUserData(IncrementalFindAction.SEARCH_DISABLED, true);
        this.myConsolePromptDecorator = new ConsolePromptDecorator(this.myConsoleEditor);
        this.myConsoleEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myConsolePromptDecorator);
        this.myBusConnection = this.getProject().getMessageBus().connect();
        ApplicationManager.getApplication().invokeLater(() -> this.installEditorFactoryListener(), o -> Disposer.isDisposed((Disposable)this.myBusConnection));
    }

    public void initComponent() {
        this.myConsoleEditor.setContextMenuGroupId("ConsoleEditorPopupMenu");
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getVirtualFile(), this.myConsoleEditor.getColorsScheme(), this.getProject()));
        this.myConsolePromptDecorator.update();
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.myHelper.virtualFile;
    }

    public EditorEx getEditor() {
        return this.myConsoleEditor;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        return (EditorEx)ObjectUtils.notNull((Object)this.myCurrentEditor, (Object)this.myConsoleEditor);
    }

    public Document getDocument() {
        return this.myEditorDocument;
    }

    public JComponent getComponent() {
        return this.myConsoleEditor.getComponent();
    }

    @NotNull
    public ConsolePromptDecorator getConsolePromptDecorator() {
        return this.myConsolePromptDecorator;
    }

    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.getVirtualFile());
            this.myCurrentEditor = this.myConsoleEditor;
        }
        this.myConsoleEditor.getComponent().setVisible(consoleEditorEnabled);
    }

    private Project getProject() {
        return this.myHelper.project;
    }

    public final boolean isConsoleEditorEnabled() {
        return this.myConsoleEditor.getComponent().isVisible();
    }

    @Nullable
    public String getPrompt() {
        return this.myConsolePromptDecorator.getMainPrompt();
    }

    @NotNull
    public ConsoleViewContentType getPromptAttributes() {
        return this.myConsolePromptDecorator.getPromptAttributes();
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        this.myConsolePromptDecorator.setPromptAttributes(textAttributes);
    }

    public void setPrompt(@Nullable String prompt) {
        this.setPromptInner(prompt);
    }

    public void setEditable(boolean editable) {
        this.myConsoleEditor.setRendererMode(!editable);
        this.myConsolePromptDecorator.update();
    }

    public boolean isEditable() {
        return !this.myConsoleEditor.isRendererMode();
    }

    private void setPromptInner(@Nullable String prompt) {
        if (!this.myConsoleEditor.isDisposed()) {
            this.myConsolePromptDecorator.setMainPrompt(prompt != null ? prompt : "");
        }
    }

    private void installEditorFactoryListener() {
        FileEditorManagerListener fileEditorListener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (ConsoleExecutionEditor.this.myConsoleEditor == null || !Comparing.equal((Object)file2, (Object)ConsoleExecutionEditor.this.getVirtualFile())) {
                    return;
                }
                Editor selectedTextEditor = source.getSelectedTextEditor();
                for (FileEditor fileEditor : source.getAllEditors(file2)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    EditorEx editor = (EditorEx)((TextEditor)fileEditor).getEditor();
                    editor.addFocusListener(ConsoleExecutionEditor.this.myFocusListener);
                    if (selectedTextEditor == editor) {
                        ConsoleExecutionEditor.this.myCurrentEditor = editor;
                    }
                    EmptyAction.registerActionShortcuts((JComponent)editor.getComponent(), (JComponent)ConsoleExecutionEditor.this.myConsoleEditor.getComponent());
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (!Comparing.equal((Object)file2, (Object)ConsoleExecutionEditor.this.getVirtualFile())) {
                    return;
                }
                if (!Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN)) && ConsoleExecutionEditor.this.myCurrentEditor != null && ConsoleExecutionEditor.this.myCurrentEditor.isDisposed()) {
                    ConsoleExecutionEditor.this.myCurrentEditor = null;
                }
            }
        };
        this.myBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (editorManager.isFileOpen(this.getVirtualFile())) {
            fileEditorListener.fileOpened(editorManager, this.getVirtualFile());
        }
    }

    public void dispose() {
        this.myBusConnection.deliverImmediately();
        Disposer.dispose((Disposable)this.myBusConnection);
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
    }

    public void setInputText(@NotNull String query) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> this.myConsoleEditor.getDocument().setText(StringUtil.convertLineSeparators((String)query)));
    }
}

