/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.UserActivityProviderComponent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesComponent
extends LabeledComponent<TextFieldWithBrowseButton>
implements UserActivityProviderComponent {
    @NonNls
    private static final String ENVS = "envs";
    @NonNls
    public static final String ENV = "env";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String VALUE = "value";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String ENV_VARIABLES = "ENV_VARIABLES";
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVars = new EnvironmentVariablesTextFieldWithBrowseButton();

    public EnvironmentVariablesComponent() {
        this.setComponent((JComponent)((Object)this.myEnvVars));
        this.setText(ExecutionBundle.message((String)"environment.variables.component.title", (Object[])new Object[0]));
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        this.myEnvVars.setEnvs(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.myEnvVars.getEnvs();
    }

    public boolean isPassParentEnvs() {
        return this.myEnvVars.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvVars.setPassParentEnvs(passParentEnvs);
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        return this.myEnvVars.getData();
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        this.myEnvVars.setData(envData);
    }

    public void reset(CommonProgramRunConfigurationParameters s) {
        this.setEnvs(s.getEnvs());
        this.setPassParentEnvs(s.isPassParentEnvs());
    }

    public void apply(CommonProgramRunConfigurationParameters s) {
        s.setEnvs(this.getEnvs());
        s.setPassParentEnvs(this.isPassParentEnvs());
    }

    public static void readExternal(Element element2, Map<String, String> envs) {
        Element envsElement = element2.getChild(ENVS);
        if (envsElement != null) {
            for (Element envElement : envsElement.getChildren(ENV)) {
                String envName = envElement.getAttributeValue(NAME);
                String envValue = envElement.getAttributeValue(VALUE);
                if (envName == null || envValue == null) continue;
                envs.put(envName, envValue);
            }
        } else {
            for (Element o : element2.getChildren(OPTION)) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)ENV_VARIABLES)) continue;
                EnvironmentVariablesComponent.splitVars(envs, o.getAttributeValue(VALUE));
                break;
            }
        }
    }

    private static void splitVars(Map<String, String> envs, String val) {
        if (val != null) {
            String[] envVars;
            for (String envVar : envVars = val.split(";")) {
                int idx = envVar.indexOf(61);
                if (idx <= -1) continue;
                envs.put(envVar.substring(0, idx), idx < envVar.length() - 1 ? envVar.substring(idx + 1) : "");
            }
        }
    }

    public static void writeExternal(@NotNull Element element2, @NotNull Map<String, String> envs) {
        if (envs.isEmpty()) {
            return;
        }
        Element envsElement = new Element(ENVS);
        for (String envName : envs.keySet()) {
            Element envElement = new Element(ENV);
            envElement.setAttribute(NAME, envName);
            envElement.setAttribute(VALUE, envs.get(envName));
            envsElement.addContent(envElement);
        }
        element2.addContent(envsElement);
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        this.myEnvVars.addChangeListener(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        this.myEnvVars.removeChangeListener(changeListener);
    }
}

