/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor) {
        super(ExecutionBundle.messagePointer((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), Presentation.NULL_STRING, IconLoader.createLazy(() -> executor.getIcon()));
        this.myExecutor = executor;
    }

    @Override
    protected void perform(@NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        RunManagerEx runManager = (RunManagerEx)context.getRunManager();
        if (configuration == null) {
            configuration = context.getConfiguration();
            if (configuration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration);
        }
        if (Registry.is((String)"select.run.configuration.from.context")) {
            runManager.setSelectedConfiguration(configuration);
        }
        if (LOG.isDebugEnabled()) {
            String configurationClass = configuration.getConfiguration().getClass().getName();
            LOG.debug(String.format("Execute run configuration: %s", configurationClass));
        }
        ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)this.myExecutor, null, null, (DataContext)context.getDataContext());
    }

    @Override
    protected boolean isEnabledFor(@NotNull RunConfiguration configuration) {
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner<?> getRunner(@NotNull RunConfiguration configuration) {
        return ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(Presentation presentation2, @NotNull String actionText, ConfigurationContext context) {
        presentation2.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context);
        presentation2.setEnabled(((Boolean)b.first).booleanValue());
        presentation2.setVisible(((Boolean)b.second).booleanValue());
    }

    @Override
    protected void approximatePresentationByPreviousAvailability(AnActionEvent event, ThreeState hadAnythingRunnable) {
        super.approximatePresentationByPreviousAvailability(event, hadAnythingRunnable);
        event.getPresentation().setText(this.myExecutor.getStartActionText() + "...");
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context) {
        ProgramRunner<?> runner;
        RunnerAndConfigurationSettings configuration = context.findExisting();
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        ProgramRunner<?> programRunner = runner = configuration == null ? null : this.getRunner(configuration.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        Project project = context.getProject();
        return Pair.create((Object)(!ExecutionManager.getInstance((Project)project).isStarting(this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }

    @Override
    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        ArrayList<AnAction> childActions = new ArrayList<AnAction>(super.createChildActions(context, configurations));
        boolean isMultipleConfigurationsFromAlternativeLocations = configurations.size() > 1 && configurations.get(0).isFromAlternativeLocation();
        boolean isRunAction = this.myExecutor.getId().equals("Run");
        if (isMultipleConfigurationsFromAlternativeLocations && isRunAction) {
            childActions.add(this.runAllConfigurationsAction(context, configurations));
        }
        return childActions;
    }

    @NotNull
    private AnAction runAllConfigurationsAction(final @NotNull ConfigurationContext context, final @NotNull List<? extends ConfigurationFromContext> configurationsFromContext) {
        return new AnAction(CommonBundle.message((String)"action.text.run.all", (Object[])new Object[0]), ExecutionBundle.message((String)"run.all.configurations.available.in.this.context", (Object[])new Object[0]), AllIcons.RunConfigurations.Compound){

            public void actionPerformed(@NotNull AnActionEvent e) {
                long groupId2 = ExecutionEnvironment.getNextUnusedExecutionId();
                List types = ContainerUtil.map((Collection)configurationsFromContext, context1 -> context1.getConfiguration().getType());
                SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard((Project)context.getProject(), (Collection)types);
                for (ConfigurationFromContext configuration : configurationsFromContext) {
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration.getConfigurationSettings(), (Executor)RunContextAction.this.myExecutor, (long)groupId2);
                }
            }
        };
    }
}

