/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PauseOutputAction
extends ToggleAction
implements DumbAware {
    public PauseOutputAction() {
        super(ExecutionBundle.messagePointer((String)"run.configuration.pause.output.action.name", (Object[])new Object[0]), AllIcons.Actions.Pause);
    }

    @Nullable
    private static ConsoleView getConsoleView(AnActionEvent event) {
        return (ConsoleView)event.getData(LangDataKeys.CONSOLE_VIEW);
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        ConsoleView consoleView = PauseOutputAction.getConsoleView(event);
        return consoleView != null && consoleView.isOutputPaused();
    }

    public void setSelected(@NotNull AnActionEvent event, boolean flag) {
        ConsoleView consoleView = PauseOutputAction.getConsoleView(event);
        if (consoleView != null) {
            consoleView.setOutputPaused(flag);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        Presentation presentation2 = event.getPresentation();
        ConsoleView consoleView = PauseOutputAction.getConsoleView(event);
        if (consoleView == null || !consoleView.canPause()) {
            presentation2.setEnabled(false);
        } else {
            ProcessHandler handler2;
            RunContentDescriptor descriptor2 = StopAction.getRecentlyStartedContentDescriptor(event.getDataContext());
            ProcessHandler processHandler2 = handler2 = descriptor2 != null ? descriptor2.getProcessHandler() : null;
            if (handler2 != null && !handler2.isProcessTerminated()) {
                presentation2.setEnabled(true);
            } else if (consoleView.hasDeferredOutput()) {
                presentation2.setEnabled(true);
            } else {
                presentation2.setEnabled(false);
            }
        }
    }
}

