/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ChooseRunConfigurationPopupAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        new ChooseRunConfigurationPopup(project, this.getAdKey(), this.getDefaultExecutor(), this.getAlternativeExecutor()).show();
    }

    protected Executor getDefaultExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    protected Executor getAlternativeExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById("Debug");
    }

    protected String getAdKey() {
        return "run.configuration.alternate.action.ad";
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        presentation2.setEnabled(true);
        if (project == null || project.isDisposed()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (null == this.getDefaultExecutor()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setEnabledAndVisible(true);
    }

    public boolean isDumbAware() {
        return true;
    }
}

