/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InputRedirectAware
extends RunConfiguration {
    public static final List<String> TYPES_WITH_REDIRECT_AWARE_UI = ContainerUtil.immutableList((Object[])new String[]{"Application", "Java Scratch", "JUnit", "JarApplication"});

    @NotNull
    public InputRedirectOptions getInputRedirectOptions();

    @Nullable
    public static InputRedirectOptions getInputRedirectOptions(@NotNull RunConfiguration runConfiguration) {
        return TYPES_WITH_REDIRECT_AWARE_UI.contains(runConfiguration.getType().getId()) ? ((InputRedirectAware)runConfiguration).getInputRedirectOptions() : null;
    }

    @Nullable
    public static File getInputFile(@NotNull RunConfiguration configuration) {
        InputRedirectOptions inputRedirectOptions = InputRedirectAware.getInputRedirectOptions(configuration);
        if (inputRedirectOptions == null || !inputRedirectOptions.isRedirectInput()) {
            return null;
        }
        String filePath = inputRedirectOptions.getRedirectInputPath();
        if (!StringUtil.isEmpty((String)filePath)) {
            String directory;
            Module module = configuration instanceof CommonProgramRunConfigurationParameters ? ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)configuration) : null;
            filePath = FileUtil.toSystemDependentName((String)ProgramParametersUtil.expandPathAndMacros(filePath, module, configuration.getProject()));
            File file2 = new File(filePath);
            if (configuration instanceof CommonProgramRunConfigurationParameters && !FileUtil.isAbsolute((String)filePath) && (directory = ((CommonProgramRunConfigurationParameters)configuration).getWorkingDirectory()) != null) {
                file2 = new File(new File(directory), filePath);
            }
            return file2;
        }
        return null;
    }

    @Deprecated
    public static final class InputRedirectOptionsImpl
    implements InputRedirectOptions {
        public static final String REDIRECT_INPUT = "REDIRECT_INPUT";
        public static final String INPUT_FILE = "INPUT_FILE";
        @Nullable
        public String myInputFile = null;
        public boolean myRedirectInput = false;

        public void readExternal(@NotNull Element element2) {
            this.myRedirectInput = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element2, (String)REDIRECT_INPUT, (String)"false"));
            this.myInputFile = JDOMExternalizerUtil.readField((Element)element2, (String)INPUT_FILE);
        }

        public void writeExternal(Element element2) {
            if (this.myRedirectInput) {
                JDOMExternalizerUtil.writeField((Element)element2, (String)REDIRECT_INPUT, (String)"true");
            }
            if (this.myInputFile != null) {
                JDOMExternalizerUtil.writeField((Element)element2, (String)INPUT_FILE, (String)this.myInputFile);
            }
        }

        @NotNull
        public InputRedirectOptionsImpl copy() {
            InputRedirectOptionsImpl options2 = new InputRedirectOptionsImpl();
            options2.myRedirectInput = this.myRedirectInput;
            options2.myInputFile = this.myInputFile;
            return options2;
        }

        @Override
        public boolean isRedirectInput() {
            return this.myRedirectInput;
        }

        @Override
        public void setRedirectInput(boolean value2) {
            this.myRedirectInput = value2;
        }

        @Override
        @Nullable
        public String getRedirectInputPath() {
            return this.myInputFile;
        }

        @Override
        public void setRedirectInputPath(String value2) {
            this.myInputFile = value2;
        }
    }

    public static interface InputRedirectOptions {
        public boolean isRedirectInput();

        public void setRedirectInput(boolean var1);

        @Nullable
        public String getRedirectInputPath();

        public void setRedirectInputPath(String var1);
    }
}

