/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance(ExecutionHelper.class);

    private ExecutionHelper() {
    }

    public static void showErrors(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull String tabDisplayName, @Nullable VirtualFile file2) {
        ExecutionHelper.showExceptions(myProject, errors, Collections.emptyList(), tabDisplayName, file2);
    }

    public static void showExceptions(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings, @NotNull String tabDisplayName, @Nullable VirtualFile file2) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !errors.isEmpty()) {
            throw new RuntimeException(errors.get(0));
        }
        errors.forEach(it -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got error: ", (Throwable)it);
            } else {
                LOG.warn("Got error: " + it.getMessage());
            }
        });
        warnings.forEach(it -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got warning: ", (Throwable)it);
            } else {
                LOG.warn("Got warning: " + it.getMessage());
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            if (myProject.isDisposed()) {
                return;
            }
            if (errors.isEmpty() && warnings.isEmpty()) {
                ContentManagerUtil.cleanupContents(null, myProject, tabDisplayName);
                return;
            }
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                StringBuilder builder2 = new StringBuilder();
                builder2.append("Exceptions occurred:");
                for (Exception exception : errors) {
                    builder2.append("\n");
                    builder2.append(exception.getMessage());
                }
                builder2.append("Warnings occurred:");
                for (Exception exception : warnings) {
                    builder2.append("\n");
                    builder2.append(exception.getMessage());
                }
                Messages.showErrorDialog((String)builder2.toString(), (String)ExecutionBundle.message((String)"execution.error", (Object[])new Object[0]));
                return;
            }
            ExecutionHelper.addMessages(4, errors, errorTreeView, file2, "Unknown Error");
            ExecutionHelper.addMessages(5, warnings, errorTreeView, file2, "Unknown Warning");
            ToolWindowManager.getInstance((Project)myProject).getToolWindow("Messages").activate(null);
        });
    }

    private static void addMessages(int messageCategory, @NotNull List<? extends Exception> exceptions, @NotNull ErrorViewPanel errorTreeView, @Nullable VirtualFile file2, @NotNull String defaultMessage) {
        for (Exception exception : exceptions) {
            String[] messages;
            String message = exception.getMessage();
            String[] stringArray = messages = StringUtil.isNotEmpty((String)message) ? StringUtil.splitByLines((String)message) : ArrayUtilRt.EMPTY_STRING_ARRAY;
            if (messages.length == 0) {
                messages = new String[]{defaultMessage};
            }
            errorTreeView.addMessage(messageCategory, messages, file2, -1, -1, null);
        }
    }

    public static void showOutput(@NotNull Project myProject, @NotNull ProcessOutput output, @NotNull String tabDisplayName, @Nullable VirtualFile file2, boolean activateWindow) {
        String stdout = output.getStdout();
        String stderr = output.getStderr();
        if (ApplicationManager.getApplication().isUnitTestMode() && !stdout.isEmpty() && !stderr.isEmpty()) {
            throw new RuntimeException("STDOUT:\n" + stdout + "\nSTDERR:\n" + stderr);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String[] stderrLines;
            String[] stdoutLines;
            if (myProject.isDisposed()) {
                return;
            }
            String stdOutTitle = "[Stdout]:";
            String stderrTitle = "[Stderr]:";
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                Messages.showErrorDialog((String)("[Stdout]:\n" + stdout + "\n" + "[Stderr]:" + "\n" + stderr), (String)ExecutionBundle.message((String)"process.output", (Object[])new Object[0]));
                return;
            }
            if (!StringUtil.isEmpty((String)stdout) && (stdoutLines = StringUtil.splitByLines((String)stdout)).length > 0) {
                if (StringUtil.isEmpty((String)stderr)) {
                    errorTreeView.addMessage(1, stdoutLines, file2, -1, -1, null);
                } else if (file2 == null) {
                    errorTreeView.addMessage(1, stdoutLines, "[Stdout]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stdout]:"}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, new String[]{""}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, stdoutLines, file2, -1, -1, null);
                }
            }
            if (!StringUtil.isEmpty((String)stderr) && (stderrLines = StringUtil.splitByLines((String)stderr)).length > 0) {
                if (file2 == null) {
                    errorTreeView.addMessage(1, stderrLines, "[Stderr]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stderr]:"}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, ArrayUtilRt.EMPTY_STRING_ARRAY, file2, -1, -1, null);
                    errorTreeView.addMessage(1, stderrLines, file2, -1, -1, null);
                }
            }
            errorTreeView.addMessage(1, new String[]{"Process finished with exit code " + output.getExitCode()}, null, -1, -1, null);
            if (activateWindow) {
                ToolWindowManager.getInstance((Project)myProject).getToolWindow("Messages").activate(null);
            }
        });
    }

    private static void openMessagesView(@NotNull ErrorViewPanel errorTreeView, @NotNull Project myProject, @NotNull String tabDisplayName) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(myProject, () -> {
            MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
            Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
            messageView.getContentManager().addContent(content2);
            Disposer.register((Disposable)content2, (Disposable)errorTreeView);
            messageView.getContentManager().setSelectedContent(content2);
            ContentManagerUtil.cleanupContents(content2, myProject, tabDisplayName);
        }, ExecutionBundle.message((String)"open.message.view", (Object[])new Object[0]), null);
    }

    public static Collection<RunContentDescriptor> findRunningConsoleByTitle(Project project, @NotNull NotNullFunction<? super String, Boolean> titleMatcher) {
        return ExecutionHelper.findRunningConsole(project, (NotNullFunction<? super RunContentDescriptor, Boolean>)((NotNullFunction)selectedContent -> (Boolean)titleMatcher.fun((Object)selectedContent.getDisplayName())));
    }

    public static Collection<RunContentDescriptor> findRunningConsole(@NotNull Project project, @NotNull NotNullFunction<? super RunContentDescriptor, Boolean> descriptorMatcher) {
        Ref ref = new Ref();
        Runnable computeDescriptors = () -> {
            ToolWindow toolWindow;
            RunContentManager contentManager2 = RunContentManager.getInstance((Project)project);
            RunContentDescriptor selectedContent = contentManager2.getSelectedContent();
            if (selectedContent != null && (toolWindow = contentManager2.getToolWindowByDescriptor(selectedContent)) != null && toolWindow.isVisible() && ((Boolean)descriptorMatcher.fun((Object)selectedContent)).booleanValue()) {
                ref.set(Collections.singletonList(selectedContent));
                return;
            }
            SmartList result2 = new SmartList();
            for (RunContentDescriptor runContentDescriptor : contentManager2.getAllDescriptors()) {
                if (!((Boolean)descriptorMatcher.fun((Object)runContentDescriptor)).booleanValue()) continue;
                result2.add(runContentDescriptor);
            }
            ref.set((Object)result2);
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            computeDescriptors.run();
        } else {
            LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed());
            ApplicationManager.getApplication().invokeAndWait(computeDescriptors);
        }
        return (Collection)ref.get();
    }

    public static List<RunContentDescriptor> collectConsolesByDisplayName(@NotNull Project project, @NotNull NotNullFunction<? super String, Boolean> titleMatcher) {
        SmartList result2 = new SmartList();
        for (RunContentDescriptor runContentDescriptor : ExecutionManagerImpl.getAllDescriptors(project)) {
            if (!((Boolean)titleMatcher.fun((Object)runContentDescriptor.getDisplayName())).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static void selectContentDescriptor(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Collection<? extends RunContentDescriptor> consoles, String selectDialogTitle, Consumer<? super RunContentDescriptor> descriptorConsumer) {
        if (consoles.size() == 1) {
            RunContentDescriptor descriptor3 = consoles.iterator().next();
            descriptorConsumer.consume((Object)descriptor3);
            ExecutionHelper.descriptorToFront(project, descriptor3);
        } else if (consoles.size() > 1) {
            Icon icon2 = DefaultRunExecutor.getRunExecutorInstance().getIcon();
            JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<RunContentDescriptor>(consoles)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
                label2.setText(value2.getDisplayName());
                label2.setIcon(icon2);
            })).setTitle(selectDialogTitle).setItemChosenCallback(descriptor2 -> {
                descriptorConsumer.consume(descriptor2);
                ExecutionHelper.descriptorToFront(project, descriptor2);
            }).createPopup().showInBestPositionFor(dataContext);
        }
    }

    private static void descriptorToFront(@NotNull Project project, @NotNull RunContentDescriptor descriptor2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            RunContentManager manager = RunContentManager.getInstance((Project)project);
            ToolWindow toolWindow = manager.getToolWindowByDescriptor(descriptor2);
            if (toolWindow != null) {
                toolWindow.show(null);
                manager.selectRunContent(descriptor2);
            }
        }, project.getDisposed());
    }

    public static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull GeneralCommandLine cmdline) {
        ExecutionHelper.executeExternalProcess(myProject, processHandler2, mode, cmdline.getCommandLineString());
    }

    private static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull String presentableCmdline) {
        String title;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.debug("Running " + presentableCmdline);
            processHandler2.waitFor();
            return;
        }
        String string = title = mode.getTitle() != null ? mode.getTitle() : ExecutionBundle.message((String)"progress.title.please.wait", (Object[])new Object[0]);
        final Runnable process2 = mode.cancelable() ? ExecutionHelper.createCancelableExecutionProcess(processHandler2, mode.shouldCancelFun()) : (mode.getTimeout() <= 0 ? () -> processHandler2.waitFor() : ExecutionHelper.createTimeLimitedExecutionProcess(processHandler2, mode, presentableCmdline));
        if (mode.withModalProgress() || !mode.inBackGround() && ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, title, mode.cancelable(), myProject, mode.getProgressParentComponent());
        } else if (mode.inBackGround()) {
            Task.Backgroundable task2 = new Task.Backgroundable(myProject, title, mode.cancelable()){

                public void run(@NotNull ProgressIndicator indicator) {
                    process2.run();
                }
            };
            ProgressManager.getInstance().run((Task)task2);
        } else {
            String title2 = mode.getTitle2();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null && title2 != null) {
                indicator.setText2(title2);
            }
            process2.run();
        }
    }

    private static Runnable createCancelableExecutionProcess(final @NotNull ProcessHandler processHandler2, final @Nullable BooleanSupplier cancelableFun) {
        return new Runnable(){
            private ProgressIndicator myProgressIndicator;
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myWaitThread = () -> {
                try {
                    processHandler2.waitFor();
                }
                finally {
                    this.mySemaphore.up();
                }
            };
            private final Runnable myCancelListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (myProgressIndicator != null && (myProgressIndicator.isCanceled() || !myProgressIndicator.isRunning()) || cancelableFun != null && cancelableFun.getAsBoolean() || processHandler2.isProcessTerminated()) {
                            if (processHandler2.isProcessTerminated()) break;
                            try {
                                processHandler2.destroyProcess();
                                break;
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(1000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };

            @Override
            public void run() {
                this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (this.myProgressIndicator != null && StringUtil.isEmpty((String)this.myProgressIndicator.getText())) {
                    this.myProgressIndicator.setText(ExecutionBundle.message((String)"please.wait", (Object[])new Object[0]));
                }
                LOG.assertTrue(this.myProgressIndicator != null || cancelableFun != null, (Object)"Cancelable process must have an opportunity to be canceled!");
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myWaitThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myCancelListener);
                OSProcessHandler.checkEdtAndReadAction((ProcessHandler)processHandler2);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static Runnable createTimeLimitedExecutionProcess(final @NotNull ProcessHandler processHandler2, final @NotNull ExecutionMode mode, final @NotNull String presentableCmdline) {
        final ProcessOutput outputCollected = new ProcessOutput();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String eventText = event.getText();
                if (StringUtil.isNotEmpty((String)eventText)) {
                    if (ProcessOutputType.isStdout((Key)outputType)) {
                        outputCollected.appendStdout(eventText);
                    } else if (ProcessOutputType.isStderr((Key)outputType)) {
                        outputCollected.appendStderr(eventText);
                    }
                }
            }
        });
        final Throwable invocatorStack = new Throwable();
        return new Runnable(){
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myProcessRunnable = () -> {
                try {
                    boolean finished2 = processHandler2.waitFor(1000L * (long)mode.getTimeout());
                    if (!finished2) {
                        mode.onTimeout(processHandler2, presentableCmdline, outputCollected, invocatorStack);
                        processHandler2.destroyProcess();
                    }
                }
                finally {
                    this.mySemaphore.up();
                }
            };

            @Override
            public void run() {
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myProcessRunnable);
                OSProcessHandler.checkEdtAndReadAction((ProcessHandler)processHandler2);
                this.mySemaphore.waitFor();
            }
        };
    }

    static class ErrorViewPanel
    extends NewErrorTreeViewPanel {
        ErrorViewPanel(Project project) {
            super(project, "reference.toolWindows.messages");
        }

        @Override
        protected boolean canHideWarnings() {
            return false;
        }
    }
}

