/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwosideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final TwosideContentPanel myContentPanel;
    @NotNull
    private final List<T> myHolders;
    @NotNull
    private final FocusTrackerSupport<Side> myFocusTrackerSupport;

    public TwosideDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request2, @NotNull EditorHolderFactory<T> factory2) {
        super(context, request2);
        this.myHolders = this.createEditorHolders(factory2);
        this.myFocusTrackerSupport = new FocusTrackerSupport.Twoside(this.myHolders);
        this.myContentPanel = TwosideContentPanel.createFromHolders(this.myHolders);
        this.myContentPanel.setTitles(this.createTitles());
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
    }

    @Override
    protected void onDispose() {
        this.destroyEditorHolders();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
        Float proportion = (Float)this.myContext.getUserData(DiffUserDataKeysEx.TWO_SIDE_SPLITTER_PROPORTION);
        if (proportion != null && (double)proportion.floatValue() >= 0.05 && (double)proportion.floatValue() <= 0.95) {
            this.myContentPanel.getSplitter().setProportion(proportion.floatValue());
        }
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
        float proportion = this.myContentPanel.getSplitter().getProportion();
        this.myContext.putUserData(DiffUserDataKeysEx.TWO_SIDE_SPLITTER_PROPORTION, (Object)Float.valueOf(proportion));
    }

    @NotNull
    protected List<T> createEditorHolders(@NotNull EditorHolderFactory<T> factory2) {
        List contents = this.myRequest.getContents();
        ArrayList<T> holders = new ArrayList<T>(2);
        for (int i2 = 0; i2 < 2; ++i2) {
            DiffContent content2 = (DiffContent)contents.get(i2);
            holders.add(factory2.create(content2, this.myContext));
        }
        return holders;
    }

    private void destroyEditorHolders() {
        for (EditorHolder holder : this.myHolders) {
            Disposer.dispose((Disposable)holder);
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        return DiffUtil.createSyncHeightComponents(DiffUtil.createSimpleTitles(this.myRequest));
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getCurrentEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public Side getCurrentSide() {
        return this.myFocusTrackerSupport.getCurrentSide();
    }

    protected void setCurrentSide(@NotNull Side side) {
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @NotNull
    protected List<T> getEditorHolders() {
        return this.myHolders;
    }

    @NotNull
    protected T getCurrentEditorHolder() {
        return (T)((EditorHolder)this.getCurrentSide().select(this.getEditorHolders()));
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentSide().select(this.myRequest.getContents());
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        Navigatable navigatable1 = ((DiffContent)this.getCurrentSide().select(this.getRequest().getContents())).getNavigatable();
        if (navigatable1 != null) {
            return navigatable1;
        }
        return ((DiffContent)this.getCurrentSide().other().select(this.getRequest().getContents())).getNavigatable();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2, @NotNull EditorHolderFactory<T> factory2) {
        if (!(request2 instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request2).getContents();
        if (contents.size() != 2) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content2 : contents) {
            canShow &= factory2.canShowContent(content2, context);
            wantShow |= factory2.wantShowContent(content2, context);
        }
        return canShow && wantShow;
    }
}

