/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Condition;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HighlightingLevel {
    INSPECTIONS("option.highlighting.level.inspections", AllIcons.Ide.HectorOn, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> true)),
    ADVANCED("option.highlighting.level.syntax", AllIcons.Ide.HectorSyntax, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> {
        if (rangeHighlighter.getLayer() > 3000) {
            return false;
        }
        HighlightInfo info = HighlightInfo.fromRangeHighlighter(rangeHighlighter);
        return info == null || info.getSeverity().compareTo(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) < 0;
    })),
    SIMPLE("option.highlighting.level.none", AllIcons.Ide.HectorOff, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 1000));

    @NotNull
    private final String myTextKey;
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final Condition<RangeHighlighter> myCondition;

    private HighlightingLevel(@NotNull String textKey, Icon icon2, Condition<RangeHighlighter> condition) {
        this.myTextKey = textKey;
        this.myIcon = icon2;
        this.myCondition = condition;
    }

    @Nls
    @NotNull
    public String getText() {
        return DiffBundle.message((String)this.myTextKey, (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Condition<RangeHighlighter> getCondition() {
        return this.myCondition;
    }
}

