/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftHardCacheMap<K, V> {
    @NotNull
    private final SLRUMap<K, V> mySLRUMap;
    @NotNull
    private final Map<K, V> mySoftLinkMap = ContainerUtil.createSoftValueMap();

    public SoftHardCacheMap(int protectedQueueSize, int probationalQueueSize) {
        this.mySLRUMap = new SLRUMap(protectedQueueSize, probationalQueueSize);
    }

    @Nullable
    public V get(@NotNull K key) {
        Object val = this.mySLRUMap.get(key);
        if (val != null) {
            return (V)val;
        }
        val = this.mySoftLinkMap.get(key);
        if (val != null) {
            this.mySLRUMap.put(key, val);
        }
        return (V)val;
    }

    public void put(@NotNull K key, @NotNull V value2) {
        this.mySLRUMap.put(key, value2);
        this.mySoftLinkMap.put(key, value2);
    }

    public boolean remove(@NotNull K key) {
        boolean remove1 = this.mySLRUMap.remove(key);
        boolean remove2 = this.mySoftLinkMap.remove(key) != null;
        return remove1 || remove2;
    }

    public void clear() {
        this.mySLRUMap.clear();
        this.mySoftLinkMap.clear();
    }
}

