/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffTool
implements FrameDiffTool {
    public static final ErrorDiffTool INSTANCE = new ErrorDiffTool();
    private static final Logger LOG = Logger.getInstance(ErrorDiffTool.class);

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return new MyViewer(context, request2);
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return true;
    }

    @NotNull
    public String getName() {
        return DiffBundle.message((String)"error.viewer", (Object[])new Object[0]);
    }

    @NotNull
    public static JComponent createReloadMessagePanel(@Nullable DiffContext context, @NotNull String message, @NotNull String reloadMessage, @Nullable Runnable beforeReload) {
        if (context instanceof DiffContextEx) {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color linkColor = (Color)ObjectUtils.chooseNotNull((Object)scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor(), (Object)JBUI.CurrentTheme.Link.linkColor());
            SimpleColoredComponent textLabel = new SimpleColoredComponent();
            textLabel.setTextAlign(0);
            textLabel.setOpaque(false);
            textLabel.append(message);
            SimpleColoredComponent reloadLabel = new SimpleColoredComponent();
            reloadLabel.setTextAlign(0);
            reloadLabel.setOpaque(false);
            reloadLabel.append(reloadMessage, new SimpleTextAttributes(0, linkColor), () -> {
                if (beforeReload != null) {
                    beforeReload.run();
                }
                ((DiffContextEx)context).reloadDiffRequest();
            });
            LinkMouseListenerBase.installSingleTagOn(reloadLabel);
            return DiffUtil.createMessagePanel((JComponent)JBUI.Panels.simplePanel((Component)textLabel).addToBottom((Component)reloadLabel).andTransparent());
        }
        return DiffUtil.createMessagePanel(message);
    }

    private static class MyViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final DiffRequest myRequest;
        @NotNull
        private final JComponent myPanel;

        MyViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
            this.myContext = context;
            this.myRequest = request2;
            JComponent component2 = this.createComponent(request2);
            this.myPanel = ScrollPaneFactory.createScrollPane((Component)component2, (boolean)true);
        }

        @NotNull
        private JComponent createComponent(@NotNull DiffRequest request2) {
            if (request2 instanceof ErrorDiffRequest) {
                String message = ((ErrorDiffRequest)request2).getMessage();
                return ErrorDiffTool.createReloadMessagePanel(this.myContext, message, DiffBundle.message((String)"button.reload.diff.request", (Object[])new Object[0]), null);
            }
            if (request2 instanceof MessageDiffRequest) {
                String message = ((MessageDiffRequest)request2).getMessage();
                return DiffUtil.createMessagePanel(message);
            }
            if (request2 instanceof ComponentDiffRequest) {
                return ((ComponentDiffRequest)request2).getComponent(this.myContext);
            }
            if (request2 instanceof ContentDiffRequest) {
                List contents = ((ContentDiffRequest)request2).getContents();
                for (DiffContent content2 : contents) {
                    if (!(content2 instanceof FileContent) || !FileTypes.UNKNOWN.equals(content2.getContentType())) continue;
                    VirtualFile file2 = ((FileContent)content2).getFile();
                    return UnknownFileTypeDiffRequest.createComponent(file2.getName(), this.myContext);
                }
                if (ContainerUtil.all((Collection)contents, it -> it instanceof EmptyContent)) {
                    return DiffUtil.createMessagePanel(NoDiffRequest.INSTANCE.getMessage());
                }
            }
            LOG.info("Can't show diff for " + request2.getClass().getName());
            if (request2 instanceof ContentDiffRequest) {
                for (DiffContent content3 : ((ContentDiffRequest)request2).getContents()) {
                    String type = content3.getContentType() != null ? content3.getContentType().getName() : "null";
                    LOG.info(String.format("      %s, content type: %s", content3.getClass().getName(), type));
                }
            }
            return DiffUtil.createMessagePanel(DiffBundle.message((String)"error.message.cannot.show.diff", (Object[])new Object[0]));
        }

        @NotNull
        public JComponent getComponent() {
            return this.myPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            String fileName;
            if (this.myRequest instanceof UnknownFileTypeDiffRequest && (fileName = ((UnknownFileTypeDiffRequest)this.myRequest).getFileName()) != null && FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE && this.myContext instanceof DiffContextEx) {
                ApplicationManager.getApplication().invokeLater(() -> ((DiffContextEx)this.myContext).reloadDiffRequest(), ModalityState.current());
            }
            FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
            components.needTopToolbarBorder = true;
            return components;
        }

        public void dispose() {
        }
    }
}

