/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeRequestImpl
extends TextMergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myOutput;
    @NotNull
    private final List<DocumentContent> myContents;
    @NotNull
    private final CharSequence myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;

    public TextMergeRequestImpl(@Nullable Project project, @NotNull DocumentContent output, @NotNull CharSequence originalContent, @NotNull List<DocumentContent> contents, @Nullable String title, @NotNull List<String> contentTitles) {
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myOutput = output;
        this.myOriginalContent = originalContent;
        this.myContents = contents;
        this.myTitles = contentTitles;
        this.myTitle = title;
        this.onAssigned(true);
    }

    @NotNull
    public DocumentContent getOutputContent() {
        return this.myOutput;
    }

    @NotNull
    public List<DocumentContent> getContents() {
        return this.myContents;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        return this.myTitles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyResult(@NotNull MergeResult result2) {
        try {
            CharSequence applyContent;
            switch (result2) {
                case CANCEL: {
                    applyContent = MergeUtil.shouldRestoreOriginalContentOnCancel((MergeRequest)this) ? this.myOriginalContent : null;
                    break;
                }
                case LEFT: {
                    CharSequence leftContent = ((DocumentContent)ThreeSide.LEFT.select(this.getContents())).getDocument().getImmutableCharSequence();
                    applyContent = StringUtil.convertLineSeparators((String)leftContent.toString());
                    break;
                }
                case RIGHT: {
                    CharSequence rightContent = ((DocumentContent)ThreeSide.RIGHT.select(this.getContents())).getDocument().getImmutableCharSequence();
                    applyContent = StringUtil.convertLineSeparators((String)rightContent.toString());
                    break;
                }
                case RESOLVED: {
                    applyContent = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(result2.toString());
                }
            }
            if (applyContent != null) {
                DiffUtil.executeWriteCommand(this.myOutput.getDocument(), this.myProject, null, () -> this.myOutput.getDocument().setText(applyContent));
            }
            MergeCallback.getCallback((MergeRequest)this).applyResult(result2);
        }
        finally {
            this.onAssigned(false);
        }
    }

    public void resultRetargeted() {
        this.onAssigned(false);
    }

    private void onAssigned(boolean assigned) {
        this.myOutput.onAssigned(assigned);
        for (DocumentContent content2 : this.myContents) {
            content2.onAssigned(assigned);
        }
    }
}

