/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class ExpandedDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final DiffIterable myIterable;
    private final int myOffset1;
    private final int myOffset2;

    ExpandedDiffIterable(@NotNull DiffIterable iterable, int offset1, int offset2, int length1, int length2) {
        super(length1, length2);
        this.myIterable = iterable;
        this.myOffset1 = offset1;
        this.myOffset2 = offset2;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new ShiftedChangeIterable(this.myIterable, this.myOffset1, this.myOffset2);
    }

    private static class ShiftedChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final Iterator<Range> myIterator;
        private final int myOffset1;
        private final int myOffset2;
        private Range myLast;

        ShiftedChangeIterable(@NotNull DiffIterable iterable, int offset1, int offset2) {
            this.myIterator = iterable.changes();
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }

        @Override
        public int getStart1() {
            return this.myLast.start1 + this.myOffset1;
        }

        @Override
        public int getStart2() {
            return this.myLast.start2 + this.myOffset2;
        }

        @Override
        public int getEnd1() {
            return this.myLast.end1 + this.myOffset1;
        }

        @Override
        public int getEnd2() {
            return this.myLast.end2 + this.myOffset2;
        }
    }
}

