/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseShowDiffAction
extends DumbAwareAction {
    BaseShowDiffAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        boolean canShow = this.isAvailable(e);
        presentation2.setEnabled(canShow);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation2.setVisible(canShow);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        DiffRequestChain chain = this.getDiffRequestChain(e);
        if (chain == null) {
            return;
        }
        DiffManager.getInstance().showDiff(project, chain, DiffDialogHints.DEFAULT);
    }

    protected abstract boolean isAvailable(@NotNull AnActionEvent var1);

    protected static boolean hasContent(VirtualFile file2) {
        return !(file2 instanceof VirtualFileWithoutContent);
    }

    @Nullable
    protected abstract DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent var1);

    @NotNull
    protected static MutableDiffRequestChain createMutableChainFromFiles(@Nullable Project project, @NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DiffRequestFactory requestFactory = DiffRequestFactory.getInstance();
        DiffContent content1 = contentFactory.create(project, file1);
        DiffContent content2 = contentFactory.create(project, file2);
        MutableDiffRequestChain chain = new MutableDiffRequestChain(content1, content2);
        chain.setWindowTitle(requestFactory.getTitle(file1, file2));
        chain.setTitle1(requestFactory.getContentTitle(file1));
        chain.setTitle2(requestFactory.getContentTitle(file2));
        return chain;
    }
}

