/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.DiffTool;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.diff.impl.DiffRequestPanelImpl;
import com.intellij.diff.impl.DiffWindow;
import com.intellij.diff.merge.BinaryMergeTool;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeWindow;
import com.intellij.diff.merge.TextMergeTool;
import com.intellij.diff.merge.external.AutomaticExternalMergeTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.BinaryDiffTool;
import com.intellij.diff.tools.dir.DirDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.external.ExternalMergeTool;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffManagerImpl
extends DiffManagerEx {
    public void showDiff(@Nullable Project project, @NotNull DiffRequest request2) {
        this.showDiff(project, request2, DiffDialogHints.DEFAULT);
    }

    public void showDiff(@Nullable Project project, @NotNull DiffRequest request2, @NotNull DiffDialogHints hints2) {
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request2);
        this.showDiff(project, (DiffRequestChain)requestChain, hints2);
    }

    public void showDiff(@Nullable Project project, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints2) {
        if (ExternalDiffTool.isDefault()) {
            ExternalDiffTool.show(project, requests, hints2);
            return;
        }
        this.showDiffBuiltin(project, requests, hints2);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequest request2) {
        this.showDiffBuiltin(project, request2, DiffDialogHints.DEFAULT);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequest request2, @NotNull DiffDialogHints hints2) {
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request2);
        this.showDiffBuiltin(project, (DiffRequestChain)requestChain, hints2);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints2) {
        if (Registry.is((String)"show.diff.as.editor.tab") && project != null && DiffUtil.getWindowMode(hints2) == WindowWrapper.Mode.FRAME && hints2.getWindowConsumer() == null) {
            ChainDiffVirtualFile diffFile = new ChainDiffVirtualFile(requests, DiffBundle.message((String)"label.default.diff.editor.tab.name", (Object[])new Object[0]));
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)diffFile, true);
            return;
        }
        new DiffWindow(project, requests, hints2).show();
    }

    @NotNull
    public DiffRequestPanel createRequestPanel(@Nullable Project project, @NotNull Disposable parent, @Nullable Window window) {
        DiffRequestPanelImpl panel2 = new DiffRequestPanelImpl(project, window);
        Disposer.register((Disposable)parent, (Disposable)panel2);
        return panel2;
    }

    @NotNull
    public List<DiffTool> getDiffTools() {
        ArrayList<DiffTool> result2 = new ArrayList<DiffTool>();
        Collections.addAll(result2, DiffTool.EP_NAME.getExtensions());
        result2.add((DiffTool)SimpleDiffTool.INSTANCE);
        result2.add((DiffTool)UnifiedDiffTool.INSTANCE);
        result2.add((DiffTool)BinaryDiffTool.INSTANCE);
        result2.add((DiffTool)DirDiffTool.INSTANCE);
        return result2;
    }

    @NotNull
    public List<MergeTool> getMergeTools() {
        ArrayList<MergeTool> result2 = new ArrayList<MergeTool>();
        Collections.addAll(result2, MergeTool.EP_NAME.getExtensions());
        result2.add(TextMergeTool.INSTANCE);
        result2.add(BinaryMergeTool.INSTANCE);
        return result2;
    }

    public void showMerge(@Nullable Project project, @NotNull MergeRequest request2) {
        AutomaticExternalMergeTool tool = (AutomaticExternalMergeTool)AutomaticExternalMergeTool.EP_NAME.findFirstSafe(mergeTool -> mergeTool.canShow(project, request2));
        if (tool != null) {
            tool.show(project, request2);
            return;
        }
        if (ExternalMergeTool.isDefault()) {
            ExternalMergeTool.show(project, request2);
            return;
        }
        this.showMergeBuiltin(project, request2);
    }

    public void showMergeBuiltin(@Nullable Project project, @NotNull MergeRequest request2) {
        new MergeWindow.ForRequest(project, request2, DiffDialogHints.MODAL).show();
    }

    public void showMergeBuiltin(@Nullable Project project, @NotNull MergeRequestProducer requestProducer, @NotNull DiffDialogHints hints2) {
        new MergeWindow.ForProducer(project, requestProducer, hints2).show();
    }
}

