/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J_\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0016\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0016J(\u0010+\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/HistogramVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "classToHistogramEntryInternal", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lcom/intellij/diagnostic/hprof/visitors/HistogramVisitor$InternalHistogramEntry;", "Lkotlin/collections/HashMap;", "completed", "", "instanceCount", "", "createHistogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "postVisit", "", "preVisit", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "InternalHistogramEntry", "intellij.platform.ide.impl"})
public final class HistogramVisitor
extends HProfVisitor {
    private boolean completed;
    private long instanceCount;
    private HashMap<ClassDefinition, InternalHistogramEntry> classToHistogramEntryInternal;
    private final ClassStore classStore;

    @Override
    public void preVisit() {
        boolean bl = !this.completed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.disableAll();
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ClassDump);
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        Object object;
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.getClassForPrimitiveArray(elementType);
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        ClassDefinition classDefinition2 = classDefinition;
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition2);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition2);
            $this$getOrPut$iv.put(classDefinition2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance(numberOfElements * (long)elementType.getSize() + (long)ClassDefinition.Companion.getARRAY_PREAMBLE_SIZE());
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Object object;
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.getClassClass();
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition);
            $this$getOrPut$iv.put(classDefinition, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance((long)classDefinition.getInstanceSize() + (long)ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Object object;
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.get(arrayClassObjectId);
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition);
            $this$getOrPut$iv.put(classDefinition, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance((long)objects.length * (long)this.getVisitorContext().getIdSize() + (long)ClassDefinition.Companion.getARRAY_PREAMBLE_SIZE());
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        Object object;
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.get(classObjectId);
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition);
            $this$getOrPut$iv.put(classDefinition, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance((long)classDefinition.getInstanceSize() + (long)ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
    }

    @Override
    public void postVisit() {
        this.completed = true;
    }

    @NotNull
    public final Histogram createHistogram() {
        boolean bl = this.completed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<HistogramEntry> result2 = new ArrayList<HistogramEntry>(this.classToHistogramEntryInternal.size());
        Map $this$forEach$iv = this.classToHistogramEntryInternal;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl5 = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$internalEntry = element$iv = iterator2.next();
            boolean bl6 = false;
            Map.Entry entry = $dstr$_u24__u24$internalEntry;
            boolean bl7 = false;
            InternalHistogramEntry internalEntry = (InternalHistogramEntry)entry.getValue();
            result2.add(internalEntry.asHistogramEntry());
        }
        List $this$sortByDescending$iv = result2;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            boolean bl8 = false;
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    HistogramEntry e = (HistogramEntry)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(e.getTotalInstances());
                    e = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = e.getTotalInstances();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            });
        }
        return new Histogram((List<HistogramEntry>)result2, this.instanceCount);
    }

    public HistogramVisitor(@NotNull ClassStore classStore) {
        this.classStore = classStore;
        this.classToHistogramEntryInternal = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/HistogramVisitor$InternalHistogramEntry;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "totalBytes", "", "totalInstances", "addInstance", "", "sizeInBytes", "asHistogramEntry", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "intellij.platform.ide.impl"})
    public static final class InternalHistogramEntry {
        private long totalInstances;
        private long totalBytes;
        private final ClassDefinition classDefinition;

        public final void addInstance(long sizeInBytes) {
            long l = this.totalInstances;
            this.totalInstances = l + 1L;
            this.totalBytes += sizeInBytes;
        }

        @NotNull
        public final HistogramEntry asHistogramEntry() {
            return new HistogramEntry(this.classDefinition, this.totalInstances, this.totalBytes);
        }

        public InternalHistogramEntry(@NotNull ClassDefinition classDefinition) {
            this.classDefinition = classDefinition;
        }
    }
}

