/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.WindowsDefenderFixAction;
import com.intellij.diagnostic.WindowsDefenderNotification;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.local.NativeFileWatcherImpl;
import com.intellij.util.Restarter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsDefenderChecker {
    private static final Logger LOG = Logger.getInstance(WindowsDefenderChecker.class);
    private static final Pattern WINDOWS_ENV_VAR_PATTERN = Pattern.compile("%([^%]+?)%");
    private static final Pattern WINDOWS_DEFENDER_WILDCARD_PATTERN = Pattern.compile("[?*]");
    private static final int WMIC_COMMAND_TIMEOUT_MS = 10000;
    private static final int POWERSHELL_COMMAND_TIMEOUT_MS = 10000;
    private static final int MAX_POWERSHELL_STDERR_LENGTH = 500;
    private static final String IGNORE_VIRUS_CHECK = "ignore.virus.scanning.warn.message";

    public static WindowsDefenderChecker getInstance() {
        return (WindowsDefenderChecker)ServiceManager.getService(WindowsDefenderChecker.class);
    }

    public boolean isVirusCheckIgnored(Project project) {
        return PropertiesComponent.getInstance().isTrueValue(IGNORE_VIRUS_CHECK) || PropertiesComponent.getInstance((Project)project).isTrueValue(IGNORE_VIRUS_CHECK);
    }

    public CheckResult checkWindowsDefender(@NotNull Project project) {
        Boolean windowsDefenderActive = WindowsDefenderChecker.isWindowsDefenderActive();
        if (windowsDefenderActive == null || !windowsDefenderActive.booleanValue()) {
            LOG.info("Windows Defender status: not used");
            return new CheckResult(RealtimeScanningStatus.SCANNING_DISABLED, Collections.emptyMap());
        }
        RealtimeScanningStatus scanningStatus = WindowsDefenderChecker.getRealtimeScanningEnabled();
        if (scanningStatus == RealtimeScanningStatus.SCANNING_ENABLED) {
            Collection<String> excludedProcesses = WindowsDefenderChecker.getExcludedProcesses();
            List<File> processesToCheck = this.getProcessesToCheck();
            if (excludedProcesses != null && ContainerUtil.all(processesToCheck, exe -> excludedProcesses.contains(exe.getName().toLowerCase(Locale.ENGLISH))) && excludedProcesses.contains("java.exe")) {
                LOG.info("Windows Defender status: all relevant processes excluded from real-time scanning");
                return new CheckResult(RealtimeScanningStatus.SCANNING_DISABLED, Collections.emptyMap());
            }
            List<Pattern> excludedPatterns = WindowsDefenderChecker.getExcludedPatterns();
            if (excludedPatterns != null) {
                boolean anyPathNotExcluded;
                Map<Path, Boolean> pathStatuses = WindowsDefenderChecker.checkPathsExcluded(this.getImportantPaths(project), excludedPatterns);
                boolean bl = anyPathNotExcluded = !ContainerUtil.all(pathStatuses.values(), Boolean::booleanValue);
                if (anyPathNotExcluded) {
                    LOG.info("Windows Defender status: some relevant paths not excluded from real-time scanning, notifying user");
                } else {
                    LOG.info("Windows Defender status: all relevant paths excluded from real-time scanning");
                }
                return new CheckResult(scanningStatus, pathStatuses);
            }
            LOG.info("Windows Defender status: Failed to get excluded patterns");
            return new CheckResult(RealtimeScanningStatus.ERROR, Collections.emptyMap());
        }
        if (scanningStatus == RealtimeScanningStatus.ERROR) {
            LOG.info("Windows Defender status: failed to detect");
        } else {
            LOG.info("Windows Defender status: real-time scanning disabled");
        }
        return new CheckResult(scanningStatus, Collections.emptyMap());
    }

    @NotNull
    protected List<File> getProcessesToCheck() {
        File fsNotifier;
        ArrayList<File> result2 = new ArrayList<File>();
        File ideStarter = Restarter.getIdeStarter();
        if (ideStarter != null) {
            result2.add(ideStarter);
        }
        if ((fsNotifier = NativeFileWatcherImpl.getFSNotifierExecutable()) != null) {
            result2.add(fsNotifier);
        }
        return result2;
    }

    private static Boolean isWindowsDefenderActive() {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"wmic", "/Namespace:\\\\root\\SecurityCenter2", "Path", "AntivirusProduct", "Get", "displayName,productState"}), (int)10000);
            if (output.getExitCode() == 0) {
                return WindowsDefenderChecker.parseWindowsDefenderProductState(output);
            }
            LOG.warn("wmic Windows Defender check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
        }
        catch (ExecutionException e) {
            LOG.warn("wmic Windows Defender check failed", (Throwable)e);
        }
        return null;
    }

    private static Boolean parseWindowsDefenderProductState(ProcessOutput output) {
        String[] lines;
        for (String line : lines = StringUtil.splitByLines((String)output.getStdout())) {
            if (!line.startsWith("Windows Defender")) continue;
            String productStateString = StringUtil.substringAfterLast((String)line, (String)" ");
            try {
                int productState = Integer.parseInt(productStateString);
                return (productState & 0x1000) != 0;
            }
            catch (NumberFormatException e) {
                LOG.info("Unexpected wmic output format: " + line);
                return null;
            }
        }
        return false;
    }

    @Nullable
    private static List<Pattern> getExcludedPatterns() {
        String path2;
        Collection<String> paths = WindowsDefenderChecker.getWindowsDefenderProperty("ExclusionPath");
        if (paths == null) {
            return null;
        }
        if (paths.size() > 0 && (path2 = paths.iterator().next()).length() > 0 && path2.indexOf(92) < 0) {
            return null;
        }
        return ContainerUtil.map(paths, path -> WindowsDefenderChecker.wildcardsToRegex(WindowsDefenderChecker.expandEnvVars(path)));
    }

    @Nullable
    private static Collection<String> getExcludedProcesses() {
        Collection<String> processes = WindowsDefenderChecker.getWindowsDefenderProperty("ExclusionProcess");
        if (processes == null) {
            return null;
        }
        return ContainerUtil.map(processes, process2 -> process2.toLowerCase());
    }

    @NotNull
    private static RealtimeScanningStatus getRealtimeScanningEnabled() {
        Collection<String> output = WindowsDefenderChecker.getWindowsDefenderProperty("DisableRealtimeMonitoring");
        if (output == null) {
            return RealtimeScanningStatus.ERROR;
        }
        if (output.size() > 0 && output.iterator().next().startsWith("False")) {
            return RealtimeScanningStatus.SCANNING_ENABLED;
        }
        return RealtimeScanningStatus.SCANNING_DISABLED;
    }

    @Nullable
    private static Collection<String> getWindowsDefenderProperty(String propertyName) {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"" + propertyName + "\""}), (int)10000);
            if (output.getExitCode() == 0) {
                return output.getStdoutLines();
            }
            LOG.warn("Windows Defender " + propertyName + " check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
        }
        catch (ExecutionException e) {
            LOG.warn("Windows Defender " + propertyName + " check failed", (Throwable)e);
        }
        return null;
    }

    @NotNull
    protected List<Path> getImportantPaths(@NotNull Project project) {
        String homeDir = System.getProperty("user.home");
        String gradleUserHome = System.getenv("GRADLE_USER_HOME");
        String projectDir = project.getBasePath();
        ArrayList<Path> paths = new ArrayList<Path>();
        if (projectDir != null) {
            paths.add(Paths.get(projectDir, new String[0]));
        }
        paths.add(Paths.get(PathManager.getSystemPath(), new String[0]));
        if (gradleUserHome != null) {
            paths.add(Paths.get(gradleUserHome, new String[0]));
        } else {
            paths.add(Paths.get(homeDir, ".gradle"));
        }
        return paths;
    }

    @NotNull
    private static String expandEnvVars(@NotNull String path) {
        Matcher m = WINDOWS_ENV_VAR_PATTERN.matcher(path);
        StringBuffer result2 = new StringBuffer();
        while (m.find()) {
            String value2 = System.getenv(m.group(1));
            if (value2 == null) continue;
            m.appendReplacement(result2, Matcher.quoteReplacement(value2));
        }
        m.appendTail(result2);
        return result2.toString();
    }

    @NotNull
    private static Pattern wildcardsToRegex(@NotNull String path) {
        Matcher m = WINDOWS_DEFENDER_WILDCARD_PATTERN.matcher(path);
        StringBuilder sb = new StringBuilder();
        int previousWildcardEnd = 0;
        while (m.find()) {
            sb.append(Pattern.quote(path.substring(previousWildcardEnd, m.start())));
            if (m.group().equals("?")) {
                sb.append("[^\\\\]");
            } else {
                sb.append("[^\\\\]*");
            }
            previousWildcardEnd = m.end();
        }
        sb.append(Pattern.quote(path.substring(previousWildcardEnd)));
        sb.append(".*");
        return Pattern.compile(sb.toString(), 2);
    }

    @NotNull
    private static Map<Path, Boolean> checkPathsExcluded(@NotNull List<Path> paths, @NotNull List<Pattern> excludedPatterns) {
        HashMap<Path, Boolean> result2 = new HashMap<Path, Boolean>();
        for (Path path : paths) {
            if (!path.toFile().exists()) continue;
            try {
                String canonical = path.toRealPath(new LinkOption[0]).toString();
                boolean found = false;
                for (Pattern pattern : excludedPatterns) {
                    if (!pattern.matcher(canonical).matches() && !pattern.matcher(path.toString()).matches()) continue;
                    found = true;
                    result2.put(path, true);
                    break;
                }
                if (found) continue;
                result2.put(path, false);
            }
            catch (IOException e) {
                LOG.warn("Windows Defender exclusion check couldn't get real path for " + path, (Throwable)e);
            }
        }
        return result2;
    }

    public void configureActions(Project project, WindowsDefenderNotification notification) {
        notification.addAction((AnAction)new WindowsDefenderFixAction(notification.getPaths()));
        notification.addAction((AnAction)new NotificationAction(DiagnosticBundle.message("virus.scanning.dont.show.again", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                PropertiesComponent.getInstance().setValue(WindowsDefenderChecker.IGNORE_VIRUS_CHECK, "true");
            }
        });
    }

    public String getNotificationText(Set<? extends Path> nonExcludedPaths) {
        return DiagnosticBundle.message("virus.scanning.warn.message", StringUtil.join(nonExcludedPaths, (String)"<br/>"));
    }

    public String getConfigurationInstructionsUrl() {
        return "https://intellij-support.jetbrains.com/hc/en-us/articles/360006298560";
    }

    public boolean runExcludePathsCommand(Project project, Collection<Path> paths) {
        try {
            ProcessOutput output = ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-Command", "Add-MpPreference", "-ExclusionPath", StringUtil.join(paths, path -> StringUtil.wrapWithDoubleQuote((String)path.toString()), (String)",")}), (String)"");
            return output.getExitCode() == 0;
        }
        catch (ExecutionException | IOException e) {
            UIUtil.invokeLaterIfNeeded(() -> WindowsDefenderChecker.lambda$runExcludePathsCommand$4(project, (Exception)e));
            return false;
        }
    }

    private static /* synthetic */ void lambda$runExcludePathsCommand$4(Project project, Exception e) {
        Messages.showErrorDialog((Project)project, (String)DiagnosticBundle.message("virus.scanning.fix.failed", e.getMessage()), (String)DiagnosticBundle.message("virus.scanning.fix.title", new Object[0]));
    }

    public static class CheckResult {
        public final RealtimeScanningStatus status;
        public final Map<Path, Boolean> pathStatus;

        public CheckResult(RealtimeScanningStatus status, Map<Path, Boolean> pathStatus) {
            this.status = status;
            this.pathStatus = pathStatus;
        }
    }

    public static enum RealtimeScanningStatus {
        SCANNING_DISABLED,
        SCANNING_ENABLED,
        ERROR;

    }
}

