/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Layout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogMessage
extends AbstractMessage {
    private final Throwable myThrowable;
    private final String myMessage;
    private final List<Attachment> myAttachments;

    LogMessage(Throwable throwable, String message, List<Attachment> attachments) {
        this.myThrowable = ThrowableInterner.intern((Throwable)throwable);
        String str = message;
        if (str != null && throwable.getMessage() != null && (str = StringUtil.trimStart((String)str, (String)throwable.getMessage())) != message) {
            str = StringUtil.trimStart((String)str, (String)": ");
        }
        if ("null".equals(str)) {
            str = null;
        }
        this.myMessage = StringUtil.nullize((String)str, (boolean)true);
        this.myAttachments = new ArrayList<Attachment>(ContainerUtil.filter(attachments, attachment -> attachment != null));
    }

    @Override
    @NotNull
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Override
    @NotNull
    public String getThrowableText() {
        return StringUtil.join((String[])IdeaLogger.getThrowableRenderer().doRender(this.myThrowable), (String)Layout.LINE_SEP);
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.myMessage != null ? this.myMessage : "";
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        return Collections.unmodifiableList(this.myAttachments);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public synchronized void addAttachment(@NotNull Attachment attachment) {
        this.myAttachments.add(attachment);
    }

    public static IdeaLoggingEvent createEvent(@NotNull Throwable throwable, @Nullable String userMessage, Attachment ... attachments) {
        LogMessageEx message = new LogMessageEx(throwable, userMessage, Arrays.asList(attachments), null);
        return new IdeaLoggingEvent(userMessage, throwable, (Object)message);
    }
}

