/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class AttachmentFactory {
    private static final Logger LOG = Logger.getInstance(AttachmentFactory.class);
    private static final long BIG_FILE_THRESHOLD_BYTES = 51200L;

    @NotNull
    public static Attachment createContext(@NotNull Object start2, Object ... more) {
        StringBuilder builder2 = new StringBuilder(String.valueOf(start2));
        for (Object o : more) {
            builder2.append(",").append(o);
        }
        return new Attachment("current-context.txt", builder2.length() > 0 ? builder2.toString() : "(unknown)");
    }

    @NotNull
    public static Attachment createAttachment(@NotNull Document document) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return new Attachment(file2 != null ? file2.getPath() : "unknown.txt", document.getText());
    }

    @NotNull
    public static Attachment createAttachment(@NotNull VirtualFile file2) {
        return AttachmentFactory.createAttachment(file2.getPresentableUrl(), file2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Attachment createAttachment(@NotNull String path, @NotNull VirtualFile file2) {
        try (InputStream inputStream = file2.getInputStream();){
            Attachment attachment = AttachmentFactory.createAttachment(path, inputStream, file2.getLength(), file2.getFileType().isBinary());
            return attachment;
        }
        catch (IOException e) {
            return AttachmentFactory.handleException(e, file2.getPath());
        }
    }

    @NotNull
    public static Attachment createAttachment(@NotNull File file2, boolean isBinary) {
        return AttachmentFactory.createAttachment(file2.toPath(), isBinary);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Attachment createAttachment(@NotNull Path file2, boolean isBinary) {
        try (InputStream inputStream = Files.newInputStream(file2, new OpenOption[0]);){
            Attachment attachment = AttachmentFactory.createAttachment(file2.toString(), inputStream, Files.size(file2), isBinary);
            return attachment;
        }
        catch (IOException e) {
            return AttachmentFactory.handleException(e, file2.toString());
        }
    }

    private static Attachment handleException(Throwable t, String path) {
        LOG.warn("failed to create an attachment from " + path, t);
        return new Attachment(path, t);
    }

    private static Attachment createAttachment(String path, InputStream content2, long contentLength, boolean isBinary) throws IOException {
        if (contentLength >= 51200L) {
            File tempFile = FileUtil.createTempFile((String)("ij-attachment-" + PathUtilRt.getFileName((String)path) + "."), (String)(isBinary ? ".bin" : ".txt"), (boolean)true);
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                FileUtil.copy((InputStream)content2, (long)contentLength, (OutputStream)outputStream);
            }
            return new Attachment(path, tempFile, "[File is too big to display]");
        }
        byte[] bytes = FileUtil.loadBytes((InputStream)content2);
        String displayText = isBinary ? "[File is binary]" : new String(bytes, StandardCharsets.UTF_8);
        return new Attachment(path, bytes, displayText);
    }
}

