/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoreFileTypeRegistry
extends FileTypeRegistry {
    private final Map<String, FileType> myExtensionsMap = CollectionFactory.createFilePathMap();
    private final List<FileType> myAllFileTypes = new ArrayList<FileType>();

    public CoreFileTypeRegistry() {
        this.myAllFileTypes.add(UnknownFileType.INSTANCE);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        return false;
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        return this.myAllFileTypes.toArray(FileType.EMPTY_ARRAY);
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        return this.getFileTypeByFileName(file2.getNameSequence());
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        return this.getFileTypeByExtension(FileUtilRt.getExtension((String)fileName));
    }

    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        FileType result2 = this.myExtensionsMap.get(extension);
        return result2 == null ? UnknownFileType.INSTANCE : result2;
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        this.myAllFileTypes.add(fileType);
        for (String ext : extension.split(";")) {
            this.myExtensionsMap.put(ext, fileType);
        }
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        for (FileType type : this.myAllFileTypes) {
            if (!type.getName().equals(fileTypeName)) continue;
            return type;
        }
        return null;
    }
}

