/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ApplierCompleter;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLauncherImpl
extends JobLauncher {
    static final int CORES_FORK_THRESHOLD = 1;

    @Override
    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress2, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        AbstractProgressIndicatorBase wrapper2 = progress2 == null ? new StandardProgressIndicatorBase() : new SensitiveProgressWrapper(progress2);
        Boolean result2 = JobLauncherImpl.processImmediatelyIfTooFew(things, wrapper2, runInReadAction, thingProcessor);
        if (result2 != null) {
            return result2;
        }
        ProgressManager pm = ProgressManager.getInstance();
        Processor processor2 = ((CoreProgressManager)pm).isPrioritizedThread(Thread.currentThread()) ? t -> (Boolean)pm.computePrioritized(() -> thingProcessor.process(t)) : thingProcessor;
        processor2 = JobLauncherImpl.wrapWithIgnoringDumbMode(processor2);
        processor2 = ClientId.decorateProcessor(processor2);
        List failedSubTasks = Collections.synchronizedList(new ArrayList());
        ApplierCompleter<T> applier = new ApplierCompleter<T>(null, runInReadAction, failFastOnAcquireReadAction, wrapper2, things, processor2, 0, things.size(), failedSubTasks, null);
        try {
            ProgressIndicator existing = pm.getProgressIndicator();
            if (existing == progress2) {
                applier.compute();
            } else {
                ForkJoinPool.commonPool().execute(applier);
            }
            while (!applier.isDone()) {
                ProgressManager.checkCanceled();
                try {
                    applier.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
            if (applier.throwable != null) {
                throw applier.throwable;
            }
        }
        catch (ApplierCompleter.ComputationAbortedException e) {
            return false;
        }
        catch (ApplicationUtil.CannotRunReadActionException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            if (progress2 != null) {
                progress2.checkCanceled();
            }
            ProgressManager.checkCanceled();
            return false;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return applier.completeTaskWhichFailToAcquireReadAction();
    }

    private static <T> Processor<? super T> wrapWithIgnoringDumbMode(Processor<? super T> processor2) {
        DumbModeAccessType dumbModeAccessType = FileBasedIndex.getInstance().getCurrentDumbModeAccessType();
        if (dumbModeAccessType == null) {
            return processor2;
        }
        return t -> (Boolean)FileBasedIndex.getInstance().ignoreDumbMode(dumbModeAccessType, () -> processor2.process(t));
    }

    private static <T> Boolean processImmediatelyIfTooFew(@NotNull List<? extends T> things, @NotNull ProgressIndicator progress2, boolean runInReadAction, @NotNull Processor<? super T> thingProcessor) {
        if (things.isEmpty()) {
            return true;
        }
        if (things.size() <= 1 || JobSchedulerImpl.getJobPoolParallelism() <= 1 || runInReadAction && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            AtomicBoolean result2 = new AtomicBoolean(true);
            Runnable runnable2 = () -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                for (int i2 = 0; i2 < things.size(); ++i2) {
                    Object thing = things.get(i2);
                    if (thingProcessor.process(thing)) continue;
                    result2.set(false);
                    break;
                }
            }, progress2);
            if (runInReadAction) {
                ApplicationManager.getApplication().runReadAction(runnable2);
            } else {
                runnable2.run();
            }
            return result2.get();
        }
        return null;
    }

    @Override
    @NotNull
    public Job<Void> submitToJobThread(@NotNull Runnable action2, @Nullable Consumer<? super Future<?>> onDoneCallback) {
        VoidForkJoinTask task2 = new VoidForkJoinTask(action2, onDoneCallback);
        task2.submit();
        return task2;
    }

    public <T> boolean processQueue(final @NotNull BlockingQueue<T> things, final @NotNull Queue<T> failedToProcess, final @NotNull ProgressIndicator progress2, final @NotNull T tombStone, final @NotNull Processor<? super T> thingProcessor) {
        class MyTask
        implements Callable<Boolean> {
            private final int mySeq;
            private boolean result;

            MyTask(int seq) {
                this.mySeq = seq;
            }

            @Override
            public Boolean call() {
                ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }, progress2);
                return this.result;
            }

            public String toString() {
                return super.toString() + " seq=" + this.mySeq;
            }
        }
        progress2.checkCanceled();
        boolean isSmallEnough = things.contains(tombStone);
        if (isSmallEnough) {
            try {
                return new MyTask(0).call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<Future> tasks = new ArrayList<Future>();
        for (int i2 = 0; i2 < Math.max(1, JobSchedulerImpl.getJobPoolParallelism() - 1); ++i2) {
            tasks.add(ForkJoinPool.commonPool().submit((Callable)new MyTask(i2)));
        }
        boolean result2 = true;
        RuntimeException exception = null;
        for (ForkJoinTask forkJoinTask : tasks) {
            try {
                result2 &= ((Boolean)forkJoinTask.join()).booleanValue();
            }
            catch (RuntimeException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result2;
    }

    private static class VoidForkJoinTask
    implements Job<Void> {
        private final Runnable myAction;
        private final Consumer<? super Future<?>> myOnDoneCallback;
        private volatile Status myStatus;
        private final ForkJoinTask<Void> myForkJoinTask = new ForkJoinTask<Void>(){

            @Override
            public Void getRawResult() {
                return null;
            }

            @Override
            protected void setRawResult(Void value2) {
            }

            @Override
            protected boolean exec() {
                myStatus = Status.STARTED;
                try {
                    myAction.run();
                    this.complete(null);
                }
                catch (Throwable throwable) {
                    myStatus = Status.EXECUTED;
                    this.completeExceptionally(throwable);
                }
                finally {
                    myStatus = Status.EXECUTED;
                    if (myOnDoneCallback != null) {
                        myOnDoneCallback.consume((Object)this);
                    }
                }
                return true;
            }
        };

        private VoidForkJoinTask(@NotNull Runnable action2, @Nullable Consumer<? super Future<?>> onDoneCallback) {
            this.myAction = action2;
            this.myOnDoneCallback = onDoneCallback;
        }

        private void submit() {
            ForkJoinPool.commonPool().execute(this.myForkJoinTask);
        }

        @Override
        public boolean isDone() {
            boolean wasCancelled = this.myForkJoinTask.isCancelled();
            Status status = this.myStatus;
            return status == Status.EXECUTED || status == null && wasCancelled;
        }

        @Override
        public boolean isCanceled() {
            return this.myForkJoinTask.isCancelled();
        }

        @Override
        public void cancel() {
            this.myForkJoinTask.cancel(true);
        }

        @Override
        public void waitForCompletion(int millis) throws InterruptedException, TimeoutException {
            long timeout = System.currentTimeMillis() + (long)millis;
            while (!this.isDone()) {
                long toWait = timeout - System.currentTimeMillis();
                if (toWait < 0L) {
                    throw new TimeoutException();
                }
                try {
                    this.myForkJoinTask.get(toWait, TimeUnit.MILLISECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException e) {
                    ExceptionUtil.rethrow((Throwable)e.getCause());
                }
                if (this.isDone()) continue;
                ForkJoinPool.commonPool().awaitQuiescence(toWait, TimeUnit.MILLISECONDS);
            }
        }

        private static enum Status {
            STARTED,
            EXECUTED;

        }
    }
}

