/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineInspectionRVContentProvider
extends InspectionRVContentProvider {
    private final Map<String, Map<String, Set<OfflineProblemDescriptor>>> myContent;
    private final Map<String, Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult>> myResolvedDescriptor = FactoryMap.create(key -> new THashMap());

    public OfflineInspectionRVContentProvider(@NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> content2) {
        this.myContent = content2;
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        Map<String, Set<OfflineProblemDescriptor>> content2 = this.getFilteredContent(context, toolWrapper);
        return content2 != null && !content2.values().isEmpty();
    }

    @Override
    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return Collections.singletonList(tools.getDefaultState());
    }

    @Override
    public QuickFixAction @NotNull [] getCommonQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        GlobalInspectionContextImpl context = tree.getContext();
        InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
        return OfflineInspectionRVContentProvider.getCommonFixes(presentation2, tree.getSelectedDescriptors());
    }

    @Override
    public boolean isContentLoaded() {
        return false;
    }

    @Override
    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Function<? super RefEntity, CommonProblemDescriptor[]> problems2) {
        Map filteredContent = this.getFilteredContent(context, wrapper2);
        InspectionResultsView view = context.getView();
        if (filteredContent != null && !filteredContent.values().isEmpty()) {
            this.buildTree(context, filteredContent, wrapper2, descriptor2 -> {
                RefEntity element2 = descriptor2.getRefElement(context.getRefManager());
                return new InspectionRVContentProvider.RefEntityContainer<OfflineProblemDescriptor>(element2, new OfflineProblemDescriptor[]{descriptor2}){

                    @Override
                    @Nullable
                    protected String getModuleName() {
                        String module = super.getModuleName();
                        return module == null ? descriptor2.getModuleName() : module;
                    }
                };
            }, showStructure, parentNode, view.getTree().getInspectionTreeModel());
        }
    }

    @Nullable
    private Map<String, Set<OfflineProblemDescriptor>> getFilteredContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        Map<String, Set<OfflineProblemDescriptor>> content2 = this.myContent.get(toolWrapper.getShortName());
        if (content2 == null) {
            return null;
        }
        if (context.getUIOptions().FILTER_RESOLVED_ITEMS) {
            HashMap<String, Set<OfflineProblemDescriptor>> current2 = new HashMap<String, Set<OfflineProblemDescriptor>>(content2);
            content2 = null;
            Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult> resolvedDescriptors = this.myResolvedDescriptor.get(toolWrapper.getShortName());
            resolvedDescriptors.forEach((descriptor2, descriptorResolveResult) -> {
                RefEntity entity;
                if (descriptorResolveResult.isExcluded() && (entity = descriptorResolveResult.getResolvedEntity()) != null) {
                    OfflineInspectionRVContentProvider.excludeProblem(entity.getExternalName(), current2);
                }
            });
            InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
            for (RefEntity refEntity : presentation2.getResolvedElements()) {
                if (!(refEntity instanceof RefElement)) continue;
                OfflineInspectionRVContentProvider.excludeProblem(refEntity.getExternalName(), current2);
            }
            return current2;
        }
        return content2;
    }

    private static void excludeProblem(String externalName, Map<String, Set<OfflineProblemDescriptor>> content2) {
        Iterator<String> iter = content2.keySet().iterator();
        while (iter.hasNext()) {
            String packageName = iter.next();
            HashSet excluded = new HashSet(content2.get(packageName));
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                OfflineProblemDescriptor ex = (OfflineProblemDescriptor)it.next();
                if (!Comparing.strEqual((String)ex.getFQName(), (String)externalName)) continue;
                it.remove();
            }
            if (excluded.isEmpty()) {
                iter.remove();
                continue;
            }
            content2.put(packageName, excluded);
        }
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container2, @NotNull InspectionTreeNode parent) {
        InspectionToolPresentation presentation2 = context.getPresentation(toolWrapper);
        InspectionTreeModel model = context.getView().getTree().getInspectionTreeModel();
        for (OfflineProblemDescriptor descriptor2 : (OfflineProblemDescriptor[])container2.getDescriptors()) {
            OfflineDescriptorResolveResult resolveResult = this.myResolvedDescriptor.get(toolWrapper.getShortName()).computeIfAbsent(descriptor2, d -> OfflineDescriptorResolveResult.resolve(d, toolWrapper, presentation2));
            RefEntity resolvedEntity = resolveResult.getResolvedEntity();
            CommonProblemDescriptor resolvedDescriptor = resolveResult.getResolvedDescriptor();
            if (resolvedEntity != null && resolvedDescriptor != null) {
                presentation2.getProblemElements().put(resolvedEntity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{resolvedDescriptor});
                model.createProblemDescriptorNode(resolvedEntity, resolvedDescriptor, presentation2, parent);
                continue;
            }
            model.createOfflineProblemDescriptorNode(descriptor2, resolveResult, presentation2, parent);
        }
    }
}

