/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

final class InspectionTreeHtmlExportResources {
    private static final Logger LOG = Logger.getInstance(InspectionTreeHtmlExportResources.class);

    InspectionTreeHtmlExportResources() {
    }

    static void copyInspectionReportResources(@NotNull Path targetDirectory) {
        InspectionTreeHtmlExportResources.copyInspectionReportResource("styles.css", targetDirectory);
        InspectionTreeHtmlExportResources.copyInspectionReportResource("script.js", targetDirectory);
    }

    private static void copyInspectionReportResource(String resourceName, @NotNull Path targetDirectory) {
        Path resourceTargetFile = targetDirectory.resolve(resourceName);
        try {
            Files.createDirectories(resourceTargetFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Can't create file: " + resourceTargetFile.toString());
        }
        try (InputStream input = InspectionTreeHtmlExportResources.class.getClassLoader().getResourceAsStream("/inspectionReport/" + resourceName);
             OutputStream f = Files.newOutputStream(resourceTargetFile, new OpenOption[0]);){
            FileUtil.copy((InputStream)input, (OutputStream)f);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }
}

