/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixWrapper
implements IntentionAction,
PriorityAction {
    private static final Logger LOG = Logger.getInstance(QuickFixWrapper.class);
    private final ProblemDescriptor myDescriptor;
    private final LocalQuickFix myFix;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor2, int fixNumber) {
        LOG.assertTrue(fixNumber >= 0, (Object)fixNumber);
        QuickFix[] fixes = descriptor2.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix = fixes[fixNumber];
        return fix instanceof IntentionAction ? (IntentionAction)fix : new QuickFixWrapper(descriptor2, (LocalQuickFix)fix);
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor2, @NotNull LocalQuickFix fix) {
        this.myDescriptor = descriptor2;
        this.myFix = fix;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return this.getFix().getName();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement psiElement = this.myDescriptor.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        return containingFile == file2 || containingFile == null || containingFile.getViewProvider().getVirtualFile().equals(file2.getViewProvider().getVirtualFile());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement element2 = this.myDescriptor.getPsiElement();
        PsiFile fileForUndo = element2 == null ? null : element2.getContainingFile();
        LocalQuickFix fix = this.getFix();
        fix.applyFix(project, (CommonProblemDescriptor)this.myDescriptor);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        if (fileForUndo != null && !fileForUndo.equals(file2)) {
            UndoUtil.markPsiFileForUndo((PsiFile)fileForUndo);
        }
    }

    public boolean startInWriteAction() {
        return this.getFix().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.getFix().getElementToMakeWritable(file2);
    }

    @NotNull
    public LocalQuickFix getFix() {
        return this.myFix;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.myFix instanceof PriorityAction ? ((PriorityAction)this.myFix).getPriority() : PriorityAction.Priority.NORMAL;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myDescriptor.getHighlightType();
    }

    @Nullable
    public PsiFile getFile() {
        PsiElement element2 = this.myDescriptor.getPsiElement();
        return element2 != null ? element2.getContainingFile() : null;
    }

    public String toString() {
        return this.getText();
    }

    @Nullable
    public IntentionAction getFileModifierForPreview(@NotNull PsiFile target2) {
        LocalQuickFix result2 = (LocalQuickFix)ObjectUtils.tryCast((Object)this.myFix.getFileModifierForPreview(target2), LocalQuickFix.class);
        if (result2 == null) {
            return null;
        }
        final PsiElement start2 = PsiTreeUtil.findSameElementInCopy((PsiElement)this.myDescriptor.getStartElement(), (PsiFile)target2);
        final PsiElement end = PsiTreeUtil.findSameElementInCopy((PsiElement)this.myDescriptor.getEndElement(), (PsiFile)target2);
        final PsiElement psi = PsiTreeUtil.findSameElementInCopy((PsiElement)this.myDescriptor.getPsiElement(), (PsiFile)target2);
        ProblemDescriptor descriptor2 = new ProblemDescriptor(){

            public PsiElement getPsiElement() {
                return psi;
            }

            public PsiElement getStartElement() {
                return start2;
            }

            public PsiElement getEndElement() {
                return end;
            }

            public TextRange getTextRangeInElement() {
                return QuickFixWrapper.this.myDescriptor.getTextRangeInElement();
            }

            public int getLineNumber() {
                return QuickFixWrapper.this.myDescriptor.getLineNumber();
            }

            @NotNull
            public ProblemHighlightType getHighlightType() {
                return QuickFixWrapper.this.myDescriptor.getHighlightType();
            }

            public boolean isAfterEndOfLine() {
                return QuickFixWrapper.this.myDescriptor.isAfterEndOfLine();
            }

            public void setTextAttributes(TextAttributesKey key) {
            }

            @Nullable
            public ProblemGroup getProblemGroup() {
                return QuickFixWrapper.this.myDescriptor.getProblemGroup();
            }

            public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            }

            public boolean showTooltip() {
                return QuickFixWrapper.this.myDescriptor.showTooltip();
            }

            @NotNull
            public String getDescriptionTemplate() {
                return QuickFixWrapper.this.myDescriptor.getDescriptionTemplate();
            }

            public QuickFix<?> @Nullable [] getFixes() {
                return QuickFix.EMPTY_ARRAY;
            }
        };
        return new QuickFixWrapper(descriptor2, result2);
    }
}

