/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.DefaultInspectionToolResultExporter;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextEx
extends GlobalInspectionContextBase {
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextEx.class);
    private static final int MAX_OPEN_GLOBAL_INSPECTION_XML_RESULT_FILES = SystemProperties.getIntProperty((String)"max.open.global.inspection.xml.files", (int)50);
    private final ConcurrentMap<InspectionToolWrapper<?, ?>, InspectionToolResultExporter> myPresentationMap = new ConcurrentHashMap();
    protected volatile Path myOutputDir;
    protected GlobalReportedProblemFilter myGlobalReportedProblemFilter;
    private ReportedProblemFilter myReportedProblemFilter;
    Map<Path, Long> myProfile;

    public GlobalInspectionContextEx(@NotNull Project project) {
        super(project);
    }

    public void launchInspectionsOffline(@NotNull AnalysisScope scope, @NotNull Path outputPath, boolean runGlobalToolsOnly, @NotNull List<? super Path> inspectionsResults) {
        this.performInspectionsWithProgressAndExportResults(scope, runGlobalToolsOnly, true, outputPath, inspectionsResults);
    }

    public void performInspectionsWithProgressAndExportResults(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections, @NotNull Path outputDir, @NotNull List<? super Path> inspectionsResults) {
        this.cleanupTools();
        this.setCurrentScope(scope);
        Runnable action2 = () -> {
            this.myOutputDir = outputDir;
            try {
                this.performInspectionsWithProgress(scope, runGlobalToolsOnly, isOfflineInspections);
                this.exportResultsSmart(inspectionsResults, outputDir);
            }
            finally {
                this.myOutputDir = null;
            }
        };
        action2.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void exportResults(@NotNull List<? super Path> inspectionsResults, final @NotNull List<? extends Tools> inspections, @NotNull Path outputDir, @Nullable XMLOutputFactory xmlOutputFactory) {
        void var9_14;
        BufferedWriter[] bufferedWriterArray;
        if (xmlOutputFactory == null) {
            xmlOutputFactory = XMLOutputFactory.newInstance();
        }
        final BufferedWriter[] writers = new BufferedWriter[inspections.size()];
        XMLStreamWriter[] xmlWriters = new XMLStreamWriter[inspections.size()];
        try {
            int i2 = 0;
            for (Tools tools : inspections) {
                inspectionsResults.add(InspectionsResultUtil.getInspectionResultPath(outputDir, tools.getShortName()));
                try {
                    BufferedWriter writer;
                    writers[i2] = writer = InspectionsResultUtil.getWriter(outputDir, tools.getShortName());
                    XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(writer);
                    xmlWriters[i2++] = xmlWriter;
                    xmlWriter.writeStartElement("problems");
                    xmlWriter.writeCharacters("\n");
                    xmlWriter.flush();
                }
                catch (IOException | XMLStreamException e) {
                    LOG.error((Throwable)e);
                }
            }
            this.getRefManager().iterate(new RefVisitor(){

                public void visitElement(@NotNull RefEntity refEntity) {
                    int i2 = 0;
                    for (Tools tools : inspections) {
                        for (ScopeToolState state : tools.getTools()) {
                            try {
                                InspectionToolWrapper toolWrapper = state.getTool();
                                InspectionToolResultExporter presentation2 = GlobalInspectionContextEx.this.getPresentation(toolWrapper);
                                BufferedWriter writer = writers[i2];
                                if (writer == null || GlobalInspectionContextEx.this.myGlobalReportedProblemFilter != null && !GlobalInspectionContextEx.this.myGlobalReportedProblemFilter.shouldReportProblem(refEntity, toolWrapper.getShortName())) continue;
                                presentation2.exportResults(e -> {
                                    try {
                                        JbXmlOutputter.collapseMacrosAndWrite(e, (ComponentManager)GlobalInspectionContextEx.this.getProject(), writer);
                                        writer.flush();
                                    }
                                    catch (IOException e1) {
                                        throw new RuntimeException(e1);
                                    }
                                }, refEntity, d -> false);
                            }
                            catch (Throwable e2) {
                                LOG.error("Problem when exporting: " + refEntity.getExternalName(), e2);
                            }
                        }
                        ++i2;
                    }
                }
            });
            for (XMLStreamWriter xmlWriter : xmlWriters) {
                if (xmlWriter == null) continue;
                try {
                    xmlWriter.writeEndElement();
                    xmlWriter.flush();
                }
                catch (XMLStreamException e) {
                    LOG.error((Throwable)e);
                }
            }
            bufferedWriterArray = writers;
        }
        catch (Throwable throwable) {
            for (BufferedWriter writer : writers) {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            throw throwable;
        }
        int n = bufferedWriterArray.length;
        boolean bl = false;
        while (var9_14 < n) {
            BufferedWriter writer = bufferedWriterArray[var9_14];
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            ++var9_14;
        }
    }

    public void exportResultsSmart(@NotNull List<? super Path> inspectionsResults, @NotNull Path outputDir) {
        ArrayList<Tools> globalToolsWithProblems = new ArrayList<Tools>();
        ArrayList<Tools> toolsWithResultsToAggregate = new ArrayList<Tools>();
        for (Map.Entry<String, Tools> entry : this.getTools().entrySet()) {
            Tools sameTools = entry.getValue();
            boolean hasProblems = false;
            String toolName = entry.getKey();
            if (sameTools != null) {
                for (ScopeToolState toolDescr : sameTools.getTools()) {
                    InspectionToolWrapper toolWrapper = toolDescr.getTool();
                    InspectionToolResultExporter presentation2 = this.getPresentation(toolWrapper);
                    if (presentation2 instanceof AggregateResultsExporter) {
                        presentation2.updateContent();
                        if (presentation2.hasReportedProblems()) {
                            toolsWithResultsToAggregate.add(sameTools);
                            break;
                        }
                    }
                    if (toolWrapper instanceof LocalInspectionToolWrapper) {
                        hasProblems = Files.exists(InspectionsResultUtil.getInspectionResultFile(outputDir, toolWrapper.getShortName()), new LinkOption[0]);
                        continue;
                    }
                    presentation2.updateContent();
                    if (!presentation2.hasReportedProblems()) continue;
                    globalToolsWithProblems.add(sameTools);
                    LOG.assertTrue(!hasProblems, (Object)toolName);
                    break;
                }
            }
            if (!hasProblems) continue;
            try {
                Path file2 = InspectionsResultUtil.getInspectionResultPath(outputDir, sameTools.getShortName());
                inspectionsResults.add(file2);
                Files.write(file2, "</problems>".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.exportResultsWithAggregation(inspectionsResults, toolsWithResultsToAggregate, this.myOutputDir);
        if (!globalToolsWithProblems.isEmpty()) {
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            Lists.partition(globalToolsWithProblems, (int)MAX_OPEN_GLOBAL_INSPECTION_XML_RESULT_FILES).forEach(inspections -> this.exportResults(inspectionsResults, (List<? extends Tools>)inspections, outputDir, xmlOutputFactory));
        }
    }

    private void exportResultsWithAggregation(@NotNull List<? super Path> inspectionsResults, @NotNull List<? extends Tools> toolsWithResultsToAggregate, @NotNull Path outputPath) {
        for (Tools tools : toolsWithResultsToAggregate) {
            String inspectionName = tools.getShortName();
            inspectionsResults.add(InspectionsResultUtil.getInspectionResultFile(outputPath, inspectionName));
            inspectionsResults.add(InspectionsResultUtil.getInspectionResultFile(outputPath, inspectionName + "_aggregate"));
            try {
                List wrappers = ContainerUtil.map((Collection)tools.getTools(), ScopeToolState::getTool);
                InspectionsResultUtil.writeInspectionResult(this.getProject(), inspectionName, wrappers, outputPath, this::getPresentation);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public InspectionToolResultExporter getPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        InspectionToolResultExporter presentation2 = (InspectionToolResultExporter)this.myPresentationMap.get(toolWrapper);
        if (presentation2 == null) {
            presentation2 = this.createPresentation(toolWrapper);
            presentation2 = (InspectionToolResultExporter)ConcurrencyUtil.cacheOrGet(this.myPresentationMap, toolWrapper, (Object)presentation2);
        }
        return presentation2;
    }

    @NotNull
    protected InspectionToolResultExporter createPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        String presentationClass = StringUtil.notNullize((String)(toolWrapper.myEP == null ? null : toolWrapper.myEP.presentation), (String)DefaultInspectionToolResultExporter.class.getName());
        try {
            InspectionEP extension = toolWrapper.getExtension();
            ClassLoader classLoader = extension == null ? ((Object)((Object)this)).getClass().getClassLoader() : extension.getPluginDescriptor().getPluginClassLoader();
            Constructor<?> constructor = Class.forName(presentationClass, true, classLoader).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextEx.class);
            InspectionToolResultExporter presentation2 = (InspectionToolResultExporter)constructor.newInstance(new Object[]{toolWrapper, this});
            return presentation2;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ReportedProblemFilter getReportedProblemFilter() {
        return this.myReportedProblemFilter;
    }

    public void setReportedProblemFilter(ReportedProblemFilter reportedProblemFilter) {
        this.myReportedProblemFilter = reportedProblemFilter;
    }

    public GlobalReportedProblemFilter getGlobalReportedProblemFilter() {
        return this.myGlobalReportedProblemFilter;
    }

    public void setGlobalReportedProblemFilter(GlobalReportedProblemFilter reportedProblemFilter) {
        this.myGlobalReportedProblemFilter = reportedProblemFilter;
    }

    @Nullable
    public Path getOutputPath() {
        return this.myOutputDir;
    }

    public void startPathProfiling() {
        this.myProfile = new ConcurrentHashMap<Path, Long>();
    }

    public Map<Path, Long> getPathProfile() {
        return this.myProfile;
    }

    void updateProfile(VirtualFile virtualFile, long millis) {
        if (this.myProfile != null) {
            Path path = Paths.get(virtualFile.getPath(), new String[0]);
            this.myProfile.merge(path, millis, Long::sum);
        }
    }
}

