/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Descriptor {
    private static final Logger LOG = Logger.getInstance(Descriptor.class);
    @NotNull
    private final String myText;
    private final String[] myGroup;
    private final String myShortName;
    private final InspectionToolWrapper myToolWrapper;
    private final HighlightDisplayLevel myLevel;
    @Nullable
    private final NamedScope myScope;
    private final ScopeToolState myState;
    @NotNull
    private final InspectionProfileModifiableModel myInspectionProfile;
    private Element myConfig;
    private boolean myEnabled;

    public Descriptor(@NotNull ScopeToolState state, @NotNull InspectionProfileModifiableModel inspectionProfile, @NotNull Project project) {
        String[] stringArray;
        this.myState = state;
        this.myInspectionProfile = inspectionProfile;
        InspectionToolWrapper tool = state.getTool();
        this.myText = tool.getDisplayName();
        String[] groupPath = tool.getGroupPath();
        if (groupPath.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = InspectionProfileEntry.getGeneralGroupName();
        } else {
            stringArray = groupPath;
        }
        this.myGroup = stringArray;
        this.myShortName = tool.getShortName();
        this.myScope = state.getScope(project);
        HighlightDisplayKey key = HighlightDisplayKey.findOrRegister((String)this.myShortName, (String)this.myText);
        this.myLevel = inspectionProfile.getErrorLevel(key, this.myScope, project);
        this.myEnabled = inspectionProfile.isToolEnabled(key, this.myScope, project);
        this.myToolWrapper = tool;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Descriptor)) {
            return false;
        }
        Descriptor descriptor2 = (Descriptor)obj;
        return this.myShortName.equals(descriptor2.myShortName) && this.myLevel.equals(descriptor2.getLevel()) && this.myEnabled == descriptor2.isEnabled() && this.myState.equalTo(descriptor2.getState());
    }

    public int hashCode() {
        int hash = this.myShortName.hashCode() + 29 * this.myLevel.hashCode();
        return this.myScope != null ? this.myScope.hashCode() + 29 * hash : hash;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        return HighlightDisplayKey.findOrRegister((String)this.myShortName, (String)this.myText);
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public Element getConfig() {
        return this.myConfig;
    }

    public void loadConfig() {
        if (this.myConfig == null) {
            InspectionToolWrapper toolWrapper = this.getToolWrapper();
            this.myConfig = Descriptor.createConfigElement(toolWrapper);
        }
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @Nullable
    public String loadDescription() {
        this.loadConfig();
        return this.myToolWrapper.loadDescription();
    }

    @NotNull
    public InspectionProfileModifiableModel getInspectionProfile() {
        return this.myInspectionProfile;
    }

    @NotNull
    public static Element createConfigElement(InspectionToolWrapper toolWrapper) {
        Element element2 = new Element("options");
        try {
            toolWrapper.getTool().writeSettings(element2);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element2;
    }

    public String @NotNull [] getGroup() {
        return this.myGroup;
    }

    @NotNull
    public String getScopeName() {
        return this.myState.getScopeName();
    }

    @Nullable
    public NamedScope getScope() {
        return this.myScope;
    }

    @NotNull
    public ScopeToolState getState() {
        return this.myState;
    }

    public String getShortName() {
        return this.myShortName;
    }

    public String toString() {
        return this.myShortName;
    }
}

