/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    public static final Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement psiElement) {
        TextRange range2 = descriptor2 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor2).getTextRange() : null;
        return ProblemDescriptorUtil.extractHighlightedText(range2, psiElement);
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range2, @Nullable PsiElement psiElement) {
        TextRange elementRange;
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (range2 != null && (elementRange = psiElement.getTextRange()) != null && (range2 = range2.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && range2.getEndOffset() <= elementRange.getLength()) {
            ref = range2.substring(ref);
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first((String)ref, (int)100, (boolean)true);
        return ref.trim().replaceAll("\\s+", " ");
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element2, boolean appendLineNumber) {
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element2, appendLineNumber ? 1 : 0);
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element2, @FlagConstant int flags) {
        int lineNumber;
        String message = descriptor2.getDescriptionTemplate();
        if (message == null) {
            return "";
        }
        if ((flags & 1) != 0 && descriptor2 instanceof ProblemDescriptor && !message.contains("#ref") && message.contains("#loc") && (lineNumber = ((ProblemDescriptor)descriptor2).getLineNumber()) >= 0) {
            message = StringUtil.replace((String)message, (String)"#loc", (String)("(" + AnalysisBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + (lineNumber + 1) + ")"));
        }
        message = ProblemDescriptorUtil.unescapeTags(message);
        message = StringUtil.replace((String)message, (String)"#loc ", (String)"");
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        message = StringUtil.replace((String)message, (String)"#loc", (String)"");
        if ((flags & 4) != 0) {
            int endIndex;
            if (XmlStringUtil.isWrappedInHtml((String)message)) {
                message = StringUtil.removeHtmlTags((String)message, (boolean)true);
            }
            if ((endIndex = message.indexOf("#treeend")) > 0) {
                message = message.substring(0, endIndex);
            }
        }
        if (message.contains("#ref")) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor2, element2);
            message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        }
        message = StringUtil.replace((String)message, (String)"#end", (String)"");
        message = StringUtil.replace((String)message, (String)"#treeend", (String)"");
        return message.trim();
    }

    @NotNull
    public static String unescapeTags(@NotNull String message) {
        message = StringUtil.replace((String)message, (String)"<code>", (String)"'");
        message = (message = StringUtil.replace((String)message, (String)"</code>", (String)"'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : (!XmlStringUtil.isWrappedInHtml((String)message) ? StringUtil.unescapeXmlEntities((String)message) : message);
        return message;
    }

    @NotNull
    private static String unescapeXmlCode(@NotNull String message) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder2.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder2.append(StringUtil.unescapeXmlEntities((String)string));
        }
        return builder2.toString();
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element2) {
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element2, false);
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        return ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
    }

    @NotNull
    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                return HighlightInfoType.INFO;
            }
            case WEAK_WARNING: {
                return HighlightInfoType.WEAK_WARNING;
            }
            case WARNING: {
                return HighlightInfoType.WARNING;
            }
            case ERROR: {
                return HighlightInfoType.WRONG_REF;
            }
            case GENERIC_ERROR: {
                return HighlightInfoType.ERROR;
            }
            case INFORMATION: {
                return HighlightInfoType.INFORMATION;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    public static ProblemDescriptor @NotNull [] convertToProblemDescriptors(@NotNull List<? extends Annotation> annotations, @NotNull PsiFile file2) {
        if (annotations.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problems2 = new ArrayList<ProblemDescriptor>(annotations.size());
        IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache = new IdentityHashMap<IntentionAction, LocalQuickFix>();
        for (Annotation annotation : annotations) {
            LocalQuickFix[] quickFixes;
            boolean isAfterEndOfLine;
            String message;
            int endOffset;
            int startOffset;
            HighlightSeverity severity = annotation.getSeverity();
            ProblemDescriptor descriptor2 = ProblemDescriptorUtil.convertToDescriptor(file2, severity, startOffset = annotation.getStartOffset(), endOffset = annotation.getEndOffset(), message = annotation.getMessage(), isAfterEndOfLine = annotation.isAfterEndOfLine(), quickFixes = ProblemDescriptorUtil.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache));
            if (descriptor2 == null) continue;
            problems2.add(descriptor2);
        }
        return problems2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static ProblemDescriptor convertToDescriptor(@NotNull PsiFile file2, @NotNull HighlightSeverity severity, int startOffset, int endOffset, @NotNull String message, boolean isAfterEndOfLine, LocalQuickFix @NotNull [] quickFixes) {
        PsiElement startElement;
        PsiElement endElement;
        if (severity == HighlightSeverity.INFORMATION || startOffset == endOffset && !isAfterEndOfLine) {
            return null;
        }
        if (startOffset == endOffset) {
            startElement = endElement = file2.findElementAt(endOffset - 1);
        } else {
            startElement = file2.findElementAt(startOffset);
            endElement = file2.findElementAt(endOffset - 1);
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        ProblemHighlightType highlightType = HighlightInfo.convertSeverityToProblemHighlight(severity);
        return new ProblemDescriptorBase(startElement, endElement, message, quickFixes, highlightType, isAfterEndOfLine, null, true, false);
    }

    private static LocalQuickFix @NotNull [] toLocalQuickFixes(@Nullable List<? extends Annotation.QuickFixInfo> fixInfos, @NotNull Map<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (fixInfos == null || fixInfos.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i2 = 0;
        for (Annotation.QuickFixInfo quickFixInfo : fixInfos) {
            LocalQuickFix fix;
            IntentionAction intentionAction = quickFixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                fix = (LocalQuickFix)intentionAction;
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new ExternalAnnotatorInspectionVisitor.LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix = lqf;
            }
            result2[i2++] = fix;
        }
        return result2;
    }

    public static ProblemDescriptor toProblemDescriptor(@NotNull PsiFile file2, @NotNull HighlightInfo info) {
        List quickFixes = ContainerUtil.mapNotNull((Collection)((Collection)ObjectUtils.notNull(info.quickFixActionRanges, Collections.emptyList())), p -> {
            IntentionAction intention = ((HighlightInfo.IntentionActionDescriptor)p.first).getAction();
            if (intention instanceof LocalQuickFix) {
                return (LocalQuickFix)intention;
            }
            if (intention instanceof LocalQuickFixAsIntentionAdapter) {
                return ((LocalQuickFixAsIntentionAdapter)intention).getFix();
            }
            return null;
        });
        return ProblemDescriptorUtil.convertToDescriptor(file2, info.getSeverity(), info.getStartOffset(), info.getEndOffset(), info.getDescription(), info.isAfterEndOfLine(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    static @interface FlagConstant {
    }
}

