/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProblemDescriptorImpl
implements CommonProblemDescriptor {
    private static final Logger LOG = Logger.getInstance(CommonProblemDescriptorImpl.class);
    private final QuickFix[] myFixes;
    private final String myDescriptionTemplate;

    public CommonProblemDescriptorImpl(QuickFix @Nullable [] fixes, @NotNull String descriptionTemplate) {
        if (fixes != null && fixes.length > 0) {
            QuickFix[] quickFixArray = this.myFixes = ArrayUtil.contains(null, (Object[])fixes) ? (QuickFix[])ContainerUtil.mapNotNull((Object[])fixes, (Function)FunctionUtil.id(), (Object[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])fixes), (int)0)) : fixes;
            if (!(this instanceof ProblemDescriptor)) {
                for (QuickFix fix : fixes) {
                    if (!(fix instanceof LocalQuickFix)) continue;
                    LOG.error("Local quick fix expect ProblemDescriptor, but here only CommonProblemDescriptor available");
                }
            }
        } else {
            this.myFixes = fixes;
        }
        this.myDescriptionTemplate = descriptionTemplate;
    }

    @NotNull
    public String getDescriptionTemplate() {
        return this.myDescriptionTemplate;
    }

    public QuickFix @Nullable [] getFixes() {
        return this.myFixes;
    }

    public String toString() {
        return this.myDescriptionTemplate;
    }
}

