/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractInspectionCmdlineOptions;
import com.intellij.codeInspection.InspectionApplication;
import com.intellij.codeInspection.InspectionToolCmdlineOptions;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.util.ArrayUtilRt;
import com.sampullara.cli.Args;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInspectionToolStarter
implements ApplicationStarter {
    protected InspectionApplication myApplication;
    protected InspectionToolCmdlineOptions myOptions;

    protected abstract AbstractInspectionCmdlineOptions createCmdlineOptions();

    public void premain(@NotNull List<String> args) {
        this.myOptions = this.createCmdlineOptions();
        try {
            Args.parse((Object)this.myOptions, (String[])ArrayUtilRt.toStringArray(args));
        }
        catch (Exception e) {
            this.printHelpAndExit(args, this.myOptions);
            return;
        }
        if (AbstractInspectionToolStarter.verbose(this.myOptions) && !this.myOptions.suppressHelp()) {
            StringBuilder buff = new StringBuilder("Options:");
            this.printArgs(args, buff);
            buff.append("\n");
            System.out.println(buff);
        }
        try {
            this.myOptions.validate();
        }
        catch (InspectionToolCmdlineOptions.CmdlineArgsValidationException e) {
            System.err.println(e.getMessage());
            if (!this.myOptions.suppressHelp()) {
                this.printHelpAndExit(args, this.myOptions);
            }
            System.exit(1);
        }
        this.myApplication = new InspectionApplication();
        AbstractInspectionToolStarter.initApplication(this.myApplication, this.myOptions);
    }

    protected InspectionApplication getApplication() {
        return this.myApplication;
    }

    public void main(String @NotNull [] args) {
        this.myOptions.beforeStartup();
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        InspectionApplication.LOG.info("CPU cores: " + Runtime.getRuntime().availableProcessors() + "; ForkJoinPool.commonPool: " + ForkJoinPool.commonPool() + "; factory: " + ForkJoinPool.commonPool().getFactory());
        this.myApplication.startup();
    }

    private static void initApplication(@NotNull InspectionApplication application, @NotNull InspectionToolCmdlineOptions opts) {
        opts.initApplication(application);
    }

    private static boolean verbose(InspectionToolCmdlineOptions opts) {
        return opts.getVerboseLevelProperty() > 0;
    }

    protected void printArgs(@NotNull List<String> args, @NotNull StringBuilder buff) {
        if (args.size() < 2) {
            buff.append(" no arguments");
        } else {
            buff.append(ParametersList.join(args.subList(1, args.size())));
        }
    }

    protected void printHelpAndExit(@NotNull List<String> args, InspectionToolCmdlineOptions opts) {
        StringBuilder buff = new StringBuilder();
        buff.append("\n");
        buff.append("Invalid options or syntax:");
        this.printArgs(args, buff);
        System.err.println(buff);
        opts.printHelpAndExit();
    }
}

