/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MacroBase
extends Macro {
    private final String myName;
    private final String myDescription;

    public MacroBase(String name, String description) {
        this.myName = name;
        this.myDescription = description;
    }

    @Nullable
    protected abstract Result calculateResult(Expression @NotNull [] var1, ExpressionContext var2, boolean var3);

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        return this.calculateResult(params, context, false);
    }

    public Result calculateQuickResult(Expression @NotNull [] params, ExpressionContext context) {
        return this.calculateResult(params, context, true);
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.myDescription;
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    @Nullable
    public static String getTextResult(Expression @NotNull [] params, ExpressionContext context) {
        return MacroBase.getTextResult(params, context, false);
    }

    @Nullable
    public static String getTextResult(Expression @NotNull [] params, ExpressionContext context, boolean useSelection) {
        if (params.length == 1) {
            String property;
            Result result2 = params[0].calculateResult(context);
            if (result2 == null && useSelection && (property = (String)context.getProperty(ExpressionContext.SELECTION)) != null) {
                result2 = new TextResult(property);
            }
            return result2 == null ? null : result2.toString();
        }
        return null;
    }
}

