/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveTemplateCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Key<Boolean> ourShowTemplatesInTests = Key.create((String)"ShowTemplatesInTests");

    public static void setShowTemplatesInTests(boolean show2, @NotNull Disposable parentDisposable) {
        TestModeFlags.set(ourShowTemplatesInTests, (Object)show2, (Disposable)parentDisposable);
    }

    public static boolean shouldShowAllTemplates() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TestModeFlags.is(ourShowTemplatesInTests);
        }
        return Registry.is((String)"show.live.templates.in.completion");
    }

    public LiveTemplateCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                TemplateImpl template;
                boolean isAutopopup;
                ProgressManager.checkCanceled();
                PsiFile file2 = parameters2.getPosition().getContainingFile();
                if (file2 instanceof PsiPlainTextFile && EditorTextField.managesEditor(parameters2.getEditor())) {
                    return;
                }
                PrefixMatcher matcher = result2.getPrefixMatcher();
                if (matcher instanceof CamelHumpMatcher && ((CamelHumpMatcher)matcher).isTypoTolerant()) {
                    return;
                }
                Editor editor = parameters2.getEditor();
                int offset = editor.getCaretModel().getOffset();
                List<TemplateImpl> availableTemplates = TemplateManagerImpl.listApplicableTemplates(TemplateActionContext.expanding((PsiFile)file2, (Editor)editor));
                Map<TemplateImpl, String> templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor, offset, false, false);
                boolean bl = isAutopopup = parameters2.getInvocationCount() == 0;
                if (LiveTemplateCompletionContributor.this.showAllTemplates()) {
                    AtomicBoolean templatesShown = new AtomicBoolean(false);
                    CompletionResultSet finalResult = result2;
                    if (Registry.is((String)"ide.completion.show.live.templates.on.top")) {
                        LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, finalResult, isAutopopup);
                    }
                    result2.runRemainingContributors(parameters2, completionResult -> {
                        finalResult.passResult(completionResult);
                        if (completionResult.isStartMatch()) {
                            LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, finalResult, isAutopopup);
                        }
                    });
                    LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, result2, isAutopopup);
                    LiveTemplateCompletionContributor.showCustomLiveTemplates(parameters2, result2);
                    return;
                }
                if (!isAutopopup) {
                    return;
                }
                if (!LiveTemplateCompletionContributor.customTemplateAvailableAndHasCompletionItem(null, editor, file2, offset) && (template = LiveTemplateCompletionContributor.findFullMatchedApplicableTemplate(editor, offset, availableTemplates)) != null) {
                    result2.withPrefixMatcher(template.getKey()).addElement((LookupElement)new LiveTemplateLookupElementImpl(template, true));
                }
                for (Map.Entry<TemplateImpl, String> possible : templates.entrySet()) {
                    ProgressManager.checkCanceled();
                    String templateKey = possible.getKey().getKey();
                    String currentPrefix = possible.getValue();
                    result2.withPrefixMatcher(currentPrefix).restartCompletionOnPrefixChange(templateKey);
                }
            }
        });
    }

    public static boolean customTemplateAvailableAndHasCompletionItem(@Nullable Character shortcutChar, @NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        CustomTemplateCallback callback2 = new CustomTemplateCallback(editor, file2);
        TemplateActionContext templateActionContext = TemplateActionContext.expanding((PsiFile)file2, (Editor)editor);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(templateActionContext)) {
            ProgressManager.checkCanceled();
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || shortcutChar != null && customLiveTemplate.getShortcut() != shortcutChar.charValue() || !((CustomLiveTemplateBase)customLiveTemplate).hasCompletionItem(callback2, offset)) continue;
            return customLiveTemplate.computeTemplateKey(callback2) != null;
        }
        return false;
    }

    protected boolean showAllTemplates() {
        return LiveTemplateCompletionContributor.shouldShowAllTemplates();
    }

    private static void ensureTemplatesShown(AtomicBoolean templatesShown, Map<TemplateImpl, String> templates, CompletionResultSet result2, boolean isAutopopup) {
        if (!templatesShown.getAndSet(true)) {
            result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("type after non-identifier"){

                public boolean accepts(@NotNull String s, ProcessingContext context) {
                    return s.length() > 1 && !Character.isJavaIdentifierPart(s.charAt(s.length() - 2));
                }
            }));
            for (Map.Entry<TemplateImpl, String> entry : templates.entrySet()) {
                ProgressManager.checkCanceled();
                if (isAutopopup && entry.getKey().getShortcutChar() == 'N') continue;
                result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(StringUtil.notNullize((String)entry.getValue()))).addElement((LookupElement)new LiveTemplateLookupElementImpl(entry.getKey(), false));
            }
        }
    }

    private static void showCustomLiveTemplates(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        TemplateActionContext templateActionContext = TemplateActionContext.expanding((PsiFile)parameters2.getPosition().getContainingFile(), (Editor)parameters2.getEditor());
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(templateActionContext)) {
            ProgressManager.checkCanceled();
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase)) continue;
            ((CustomLiveTemplateBase)customLiveTemplate).addCompletions(parameters2, result2);
        }
    }

    @Nullable
    public static TemplateImpl findFullMatchedApplicableTemplate(@NotNull Editor editor, int offset, @NotNull Collection<? extends TemplateImpl> availableTemplates) {
        TemplateImpl template;
        Map<TemplateImpl, String> templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor, offset, true, false);
        if (templates.size() == 1 && (template = (TemplateImpl)ContainerUtil.getFirstItem(templates.keySet())) != null) {
            return template;
        }
        return null;
    }
}

