/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.UsageView;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GotoTargetHandler.class);
    private final PsiElementListCellRenderer myDefaultTargetElementRenderer = new DefaultPsiElementListCellRenderer();
    private final DefaultListCellRenderer myActionElementRenderer = new ActionCellRenderer();

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureUsedKey());
        try {
            GotoData gotoData = this.getSourceAndTargetElements(editor, file2);
            if (gotoData != null) {
                this.show(project, editor, file2, gotoData);
            } else {
                this.chooseFromAmbiguousSources(editor, file2, (Consumer<? super GotoData>)((Consumer)data2 -> this.show(project, editor, file2, (GotoData)data2)));
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]));
        }
    }

    protected void chooseFromAmbiguousSources(Editor editor, PsiFile file2, Consumer<? super GotoData> successCallback) {
    }

    @NonNls
    protected abstract String getFeatureUsedKey();

    protected boolean useEditorFont() {
        return true;
    }

    @Nullable
    protected abstract GotoData getSourceAndTargetElements(Editor var1, PsiFile var2);

    private void show(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, final @NotNull GotoData gotoData) {
        JScrollPane pane2;
        boolean finished2;
        PsiElement[] targets2 = gotoData.targets;
        List<AdditionalAction> additionalActions = gotoData.additionalActions;
        if (targets2.length == 0 && additionalActions.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, this.getNotFoundMessage(project, editor, file2));
            return;
        }
        boolean bl = finished2 = gotoData.listUpdaterTask == null || gotoData.listUpdaterTask.isFinished();
        if (targets2.length == 1 && additionalActions.isEmpty() && finished2) {
            this.navigateToElement(targets2[0]);
            return;
        }
        for (PsiElement eachTarget : targets2) {
            gotoData.renderers.put(eachTarget, GotoTargetHandler.createRenderer(gotoData, eachTarget));
        }
        String name = ((NavigationItem)gotoData.source).getName();
        String title = this.getChooserTitle(gotoData.source, name, targets2.length, finished2);
        if (this.shouldSortTargets()) {
            Arrays.sort(targets2, this.createComparator(gotoData));
        }
        ArrayList<AdditionalAction> allElements = new ArrayList<AdditionalAction>(targets2.length + additionalActions.size());
        Collections.addAll(allElements, targets2);
        allElements.addAll(additionalActions);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(allElements);
        Ref usageView = new Ref();
        builder2.setNamerForFiltering(o -> {
            if (o instanceof AdditionalAction) {
                return ((AdditionalAction)o).getText();
            }
            return this.getRenderer(o, gotoData).getElementText((PsiElement)o);
        }).setTitle(title);
        if (this.useEditorFont()) {
            builder2.setFont(EditorUtil.getEditorFont());
        }
        builder2.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                if (value2 == null) {
                    return super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                }
                if (value2 instanceof AdditionalAction) {
                    return GotoTargetHandler.this.myActionElementRenderer.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                }
                PsiElementListCellRenderer renderer = GotoTargetHandler.this.getRenderer(value2, gotoData);
                return renderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            }
        }).setItemsChosenCallback(selectedElements -> {
            for (Object element2 : selectedElements) {
                if (element2 instanceof AdditionalAction) {
                    ((AdditionalAction)element2).execute();
                    continue;
                }
                Navigatable nav = element2 instanceof Navigatable ? (Navigatable)element2 : EditSourceUtil.getDescriptor((PsiElement)((PsiElement)element2));
                try {
                    if (nav == null || !nav.canNavigate()) continue;
                    this.navigateToElement(nav);
                }
                catch (IndexNotReadyException e) {
                    DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"notification.navigation.is.not.available.while.indexing", (Object[])new Object[0]));
                }
            }
        }).withHintUpdateSupply().setMovable(true).setCancelCallback(() -> {
            BackgroundUpdaterTask task2 = gotoData.listUpdaterTask;
            if (task2 != null) {
                task2.cancelTask();
            }
            return true;
        }).setCouldPin(popup1 -> {
            usageView.set((Object)FindUtil.showInUsageView(gotoData.source, gotoData.targets, this.getFindUsagesTitle(gotoData.source, name, gotoData.targets.length), gotoData.source.getProject()));
            popup1.cancel();
            return false;
        }).setAdText(this.getAdText(gotoData.source, targets2.length));
        JBPopup popup2 = builder2.createPopup();
        JScrollPane jScrollPane = pane2 = builder2 instanceof PopupChooserBuilder ? ((PopupChooserBuilder)builder2).getScrollPane() : null;
        if (pane2 != null) {
            pane2.setBorder(null);
            pane2.setViewportBorder(null);
        }
        if (gotoData.listUpdaterTask != null) {
            Alarm alarm2 = new Alarm((Disposable)popup2);
            alarm2.addRequest(() -> {
                if (!editor.isDisposed()) {
                    popup2.showInBestPositionFor(editor);
                }
            }, 300);
            gotoData.listUpdaterTask.init(popup2, builder2.getBackgroundUpdater(), (Ref<? extends UsageView>)((Ref<UsageView>)usageView));
            ProgressManager.getInstance().run((Task)gotoData.listUpdaterTask);
        } else {
            popup2.showInBestPositionFor(editor);
        }
    }

    @NotNull
    protected PsiElementListCellRenderer getRenderer(Object value2, @NotNull GotoData gotoData) {
        PsiElementListCellRenderer renderer = gotoData.getRenderer(value2);
        return renderer != null ? renderer : this.myDefaultTargetElementRenderer;
    }

    @NotNull
    protected Comparator<PsiElement> createComparator(final @NotNull GotoData gotoData) {
        return new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return this.getComparingObject(o1).compareTo(this.getComparingObject(o2));
            }

            private Comparable getComparingObject(PsiElement o1) {
                return GotoTargetHandler.this.getRenderer(o1, gotoData).getComparingObject(o1);
            }
        };
    }

    public static PsiElementListCellRenderer createRenderer(@NotNull GotoData gotoData, @NotNull PsiElement eachTarget) {
        for (GotoTargetRendererProvider eachProvider : GotoTargetRendererProvider.EP_NAME.getExtensionList()) {
            PsiElementListCellRenderer renderer = eachProvider.getRenderer(eachTarget, gotoData);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    protected boolean navigateToElement(PsiElement target2) {
        Navigatable descriptor2;
        Navigatable navigatable = descriptor2 = target2 instanceof Navigatable ? (Navigatable)target2 : EditSourceUtil.getDescriptor((PsiElement)target2);
        if (descriptor2 != null && descriptor2.canNavigate()) {
            this.navigateToElement(descriptor2);
            return true;
        }
        return false;
    }

    protected void navigateToElement(@NotNull Navigatable descriptor2) {
        descriptor2.navigate(true);
    }

    protected boolean shouldSortTargets() {
        return true;
    }

    @Deprecated
    @NotNull
    protected String getChooserTitle(PsiElement sourceElement, String name, int length) {
        LOG.warn("Please override getChooserTitle(PsiElement, String, int, boolean) instead");
        return "";
    }

    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, @Nullable String name, int length, boolean finished2) {
        return this.getChooserTitle(sourceElement, name, length);
    }

    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        return this.getChooserTitle(sourceElement, name, length, true);
    }

    @NotNull
    protected abstract String getNotFoundMessage(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    protected String getAdText(PsiElement source, int length) {
        return null;
    }

    private static class ActionCellRenderer
    extends DefaultListCellRenderer {
        private ActionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component result2 = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            if (value2 != null) {
                AdditionalAction action2 = (AdditionalAction)value2;
                this.setText(action2.getText());
                this.setIcon(action2.getIcon());
            }
            return result2;
        }
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element2) {
            String name;
            if (element2 instanceof PsiNamedElement && (name = ((PsiNamedElement)element2).getName()) != null) {
                return name;
            }
            PsiFile file2 = element2.getContainingFile();
            if (file2 == null) {
                PsiUtilCore.ensureValid((PsiElement)element2);
                LOG.error("No file for " + element2.getClass());
                return element2.toString();
            }
            return file2.getName();
        }

        protected String getContainerText(PsiElement element2, String name) {
            if (element2 instanceof NavigationItem) {
                ItemPresentation presentation2 = ((NavigationItem)element2).getPresentation();
                return presentation2 != null ? presentation2.getLocationString() : null;
            }
            return null;
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }

    public static class GotoData {
        @NotNull
        public final PsiElement source;
        public PsiElement[] targets;
        public final List<AdditionalAction> additionalActions;
        private boolean hasDifferentNames;
        public BackgroundUpdaterTask listUpdaterTask;
        protected final Set<String> myNames;
        public Map<Object, PsiElementListCellRenderer> renderers = new HashMap<Object, PsiElementListCellRenderer>();

        public GotoData(@NotNull PsiElement source, PsiElement @NotNull [] targets2, @NotNull List<AdditionalAction> additionalActions) {
            this.source = source;
            this.targets = targets2;
            this.additionalActions = additionalActions;
            this.myNames = new HashSet<String>();
            for (PsiElement target2 : targets2) {
                if (!(target2 instanceof PsiNamedElement)) continue;
                this.myNames.add(((PsiNamedElement)target2).getName());
                if (this.myNames.size() > 1) break;
            }
            this.hasDifferentNames = this.myNames.size() > 1;
        }

        public boolean hasDifferentNames() {
            return this.hasDifferentNames;
        }

        public boolean addTarget(PsiElement element2) {
            if (ArrayUtil.find((Object[])this.targets, (Object)element2) > -1) {
                return false;
            }
            this.targets = (PsiElement[])ArrayUtil.append((Object[])this.targets, (Object)element2);
            this.renderers.put(element2, GotoTargetHandler.createRenderer(this, element2));
            if (!this.hasDifferentNames && element2 instanceof PsiNamedElement) {
                String name = (String)ReadAction.compute(() -> ((PsiNamedElement)element2).getName());
                this.myNames.add(name);
                this.hasDifferentNames = this.myNames.size() > 1;
            }
            return true;
        }

        public PsiElementListCellRenderer getRenderer(Object value2) {
            return this.renderers.get(value2);
        }
    }

    public static interface AdditionalAction {
        @NotNull
        public String getText();

        public Icon getIcon();

        public void execute();
    }
}

