/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.CtrlMouseHandler;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class BaseCtrlMouseInfo
implements CtrlMouseInfo {
    @NotNull
    private final @NotNull List<@NotNull TextRange> myRanges;

    protected BaseCtrlMouseInfo(@NotNull @NotNull List<@NotNull TextRange> ranges) {
        this.myRanges = ranges;
    }

    protected BaseCtrlMouseInfo(@NotNull PsiElement elementAtPointer) {
        this(BaseCtrlMouseInfo.getReferenceRanges(elementAtPointer));
    }

    @NotNull
    private static List<TextRange> getReferenceRanges(@NotNull PsiElement elementAtPointer) {
        if (!elementAtPointer.isPhysical()) {
            return Collections.emptyList();
        }
        int textOffset = elementAtPointer.getTextOffset();
        TextRange range2 = elementAtPointer.getTextRange();
        if (range2 == null) {
            throw new AssertionError((Object)("Null range for " + elementAtPointer + " of " + elementAtPointer.getClass()));
        }
        if (textOffset < range2.getStartOffset() || textOffset < 0) {
            CtrlMouseHandler.LOG.error("Invalid text offset " + textOffset + " of element " + elementAtPointer + " of " + elementAtPointer.getClass());
            textOffset = range2.getStartOffset();
        }
        return Collections.singletonList(new TextRange(textOffset, range2.getEndOffset()));
    }

    @Override
    @NotNull
    public final @NotNull List<@NotNull TextRange> getRanges() {
        return this.myRanges;
    }
}

