/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CommaTailType;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.EqTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupItem<T>
extends MutableLookupElement
implements Comparable {
    public static final ClassConditionKey<LookupItem> CLASS_CONDITION_KEY = ClassConditionKey.create(LookupItem.class);
    public static final Object HIGHLIGHTED_ATTR = Key.create((String)"highlighted");
    public static final Object ICON_ATTR = Key.create((String)"icon");
    public static final Object TYPE_TEXT_ATTR = Key.create((String)"typeText");
    public static final Object TAIL_TEXT_ATTR = Key.create((String)"tailText");
    public static final Object TAIL_TEXT_SMALL_ATTR = Key.create((String)"tailTextSmall");
    public static final Object FORCE_QUALIFY = Key.create((String)"FORCE_QUALIFY");
    public static final Object CASE_INSENSITIVE = Key.create((String)"CASE_INSENSITIVE");
    public static final Key<TailType> TAIL_TYPE_ATTR = Key.create((String)"myTailType");
    private Object myObject;
    private String myLookupString;
    private InsertHandler myInsertHandler;
    private double myPriority;
    private Map<Object, Object> myAttributes = null;
    public static final LookupItem[] EMPTY_ARRAY = new LookupItem[0];
    private final Set<String> myAllLookupStrings = new HashSet<String>();
    private String myPresentable;
    private AutoCompletionPolicy myAutoCompletionPolicy = AutoCompletionPolicy.SETTINGS_DEPENDENT;

    @Deprecated
    public LookupItem(T o, @NotNull @NonNls String lookupString) {
        this.setObject(o);
        this.setLookupString(lookupString);
    }

    @Deprecated
    public static LookupItem fromString(String s) {
        return new LookupItem<String>(s, s);
    }

    public void setObject(@NotNull T o) {
        this.myObject = o;
        if (o instanceof LookupValueWithPriority) {
            this.setPriority(((LookupValueWithPriority)o).getPriority());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LookupItem) {
            LookupItem item = (LookupItem)o;
            return Comparing.equal((Object)this.myObject, (Object)item.myObject) && Objects.equals(this.myLookupString, item.myLookupString) && Comparing.equal(this.myAllLookupStrings, item.myAllLookupStrings) && Comparing.equal(this.myAttributes, item.myAttributes);
        }
        return false;
    }

    public int hashCode() {
        T object = this.getObject();
        assert (object != this) : this.getClass().getName();
        return this.myAllLookupStrings.hashCode() * 239 + object.hashCode();
    }

    public String toString() {
        return this.getLookupString();
    }

    @NotNull
    public T getObject() {
        return (T)this.myObject;
    }

    @NotNull
    public String getLookupString() {
        return this.myLookupString;
    }

    public void setLookupString(@NotNull String lookupString) {
        this.myAllLookupStrings.remove("");
        this.myLookupString = lookupString;
        this.myAllLookupStrings.add(lookupString);
    }

    public Object getAttribute(Object key) {
        if (this.myAttributes != null) {
            return this.myAttributes.get(key);
        }
        return null;
    }

    public <T> T getAttribute(Key<T> key) {
        if (this.myAttributes != null) {
            return (T)this.myAttributes.get(key);
        }
        return null;
    }

    public void setAttribute(Object key, Object value2) {
        if (value2 == null && this.myAttributes != null) {
            this.myAttributes.remove(key);
            return;
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<Object, Object>(5);
        }
        this.myAttributes.put(key, value2);
    }

    public <T> void setAttribute(Key<T> key, T value2) {
        if (value2 == null && this.myAttributes != null) {
            this.myAttributes.remove(key);
            return;
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<Object, Object>(5);
        }
        this.myAttributes.put(key, value2);
    }

    public InsertHandler<? extends LookupItem> getInsertHandler() {
        return this.myInsertHandler;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        InsertHandler<LookupItem> handler2 = this.getInsertHandler();
        if (handler2 != null) {
            handler2.handleInsert(context, (LookupElement)this);
        }
        if (this.getTailType() != TailType.UNKNOWN && this.myInsertHandler == null) {
            context.setAddCompletionChar(false);
            TailType type = LookupItem.handleCompletionChar(context.getEditor(), this, context.getCompletionChar());
            type.processTail(context.getEditor(), context.getTailOffset());
        }
    }

    @Nullable
    public static TailType getDefaultTailType(char completionChar) {
        switch (completionChar) {
            case '.': {
                return new CharTailType('.', false);
            }
            case ',': {
                return CommaTailType.INSTANCE;
            }
            case ';': {
                return TailType.SEMICOLON;
            }
            case '=': {
                return EqTailType.INSTANCE;
            }
            case ' ': {
                return TailType.SPACE;
            }
            case ':': {
                return TailType.CASE_COLON;
            }
        }
        return null;
    }

    @NotNull
    public static TailType handleCompletionChar(@NotNull Editor editor, @NotNull LookupElement lookupElement, char completionChar) {
        LookupItem item;
        TailType attr;
        TailType type = LookupItem.getDefaultTailType(completionChar);
        if (type != null) {
            return type;
        }
        if (lookupElement instanceof LookupItem && (attr = (item = (LookupItem)lookupElement).getAttribute(TAIL_TYPE_ATTR)) != null) {
            return attr;
        }
        return TailType.NONE;
    }

    @NotNull
    public TailType getTailType() {
        TailType tailType = this.getAttribute(TAIL_TYPE_ATTR);
        return tailType != null ? tailType : TailType.UNKNOWN;
    }

    @NotNull
    public LookupItem<T> setTailType(@NotNull TailType type) {
        this.setAttribute((Key<T>)TAIL_TYPE_ATTR, (T)type);
        return this;
    }

    public int compareTo(@NotNull Object o) {
        if (o instanceof String) {
            return this.getLookupString().compareTo((String)o);
        }
        if (!(o instanceof LookupItem)) {
            throw new RuntimeException("Trying to compare LookupItem with " + o.getClass() + "!!!");
        }
        return this.getLookupString().compareTo(((LookupItem)o).getLookupString());
    }

    public LookupItem<T> setInsertHandler(@NotNull InsertHandler<? extends LookupElement> handler2) {
        this.myInsertHandler = handler2;
        return this;
    }

    public void renderElement(LookupElementPresentation presentation2) {
        for (ElementLookupRenderer renderer : ElementLookupRenderer.EP_NAME.getExtensionList()) {
            T object;
            if (!renderer.handlesItem(object = this.getObject())) continue;
            renderer.renderElement(this, object, presentation2);
            return;
        }
        DefaultLookupItemRenderer.INSTANCE.renderElement(this, presentation2);
    }

    public LookupItem<T> setBold() {
        this.setAttribute(HIGHLIGHTED_ATTR, "");
        return this;
    }

    public LookupItem<T> forceQualify() {
        this.setAttribute(FORCE_QUALIFY, "");
        return this;
    }

    public LookupItem<T> setAutoCompletionPolicy(AutoCompletionPolicy policy) {
        this.myAutoCompletionPolicy = policy;
        return this;
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.myAutoCompletionPolicy;
    }

    @NotNull
    public LookupItem<T> setIcon(Icon icon2) {
        this.setAttribute(ICON_ATTR, icon2);
        return this;
    }

    @NotNull
    public LookupItem<T> setPriority(double priority) {
        this.myPriority = priority;
        return this;
    }

    public final double getPriority() {
        return this.myPriority;
    }

    @NotNull
    public LookupItem<T> setPresentableText(@NotNull String displayText) {
        this.myPresentable = displayText;
        return this;
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentable;
    }

    @NotNull
    public LookupItem<T> setTailText(String text, boolean grayed) {
        this.setAttribute(TAIL_TEXT_ATTR, text);
        this.setAttribute(TAIL_TEXT_SMALL_ATTR, Boolean.TRUE);
        return this;
    }

    public LookupItem<T> addLookupStrings(String ... additionalLookupStrings) {
        ContainerUtil.addAll(this.myAllLookupStrings, (Object[])additionalLookupStrings);
        return this;
    }

    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }

    public boolean isCaseSensitive() {
        return !Boolean.TRUE.equals(this.getAttribute(CASE_INSENSITIVE));
    }
}

