/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Classifier<T> {
    protected final Classifier<T> myNext;
    private final String myName;

    protected Classifier(Classifier<T> next, @NonNls String name) {
        this.myNext = next;
        this.myName = name;
    }

    public void addElement(@NotNull T t, @NotNull ProcessingContext context) {
        if (this.myNext != null) {
            this.myNext.addElement(t, context);
        }
    }

    @NotNull
    public abstract Iterable<T> classify(@NotNull Iterable<? extends T> var1, @NotNull ProcessingContext var2);

    @NotNull
    public abstract List<Pair<T, Object>> getSortingWeights(@NotNull Iterable<? extends T> var1, @NotNull ProcessingContext var2);

    @Nullable
    public final Classifier<T> getNext() {
        return this.myNext;
    }

    public void removeElement(@NotNull T element2, @NotNull ProcessingContext context) {
        if (this.myNext != null) {
            this.myNext.removeElement(element2, context);
        }
    }

    @NotNull
    public final String getPresentableName() {
        return this.myName;
    }
}

