/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MethodInfoBlacklistFilter
implements HintInfoFilter {
    private final List<Matcher> myMatchers;

    public MethodInfoBlacklistFilter(Set<String> list2) {
        this.myMatchers = list2.stream().map(item -> MatcherConstructor.INSTANCE.createMatcher((String)item)).filter(e -> e != null).collect(Collectors.toList());
    }

    @NotNull
    public static MethodInfoBlacklistFilter forLanguage(@NotNull Language language) {
        Set<String> list2 = MethodInfoBlacklistFilter.fullBlacklist(language);
        return new MethodInfoBlacklistFilter(list2);
    }

    @Override
    public boolean showHint(@NotNull HintInfo info) {
        if (info instanceof HintInfo.MethodInfo) {
            HintInfo.MethodInfo methodInfo = (HintInfo.MethodInfo)info;
            return this.myMatchers.stream().noneMatch(e -> e.isMatching(methodInfo.getFullyQualifiedName(), methodInfo.getParamNames()));
        }
        return false;
    }

    @NotNull
    private static Set<String> fullBlacklist(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null) {
            return Collections.emptySet();
        }
        Set blackList = MethodInfoBlacklistFilter.blacklist(language);
        Language dependentLanguage = provider.getBlackListDependencyLanguage();
        if (dependentLanguage != null) {
            blackList = ContainerUtil.union(blackList, MethodInfoBlacklistFilter.blacklist(dependentLanguage));
        }
        return blackList;
    }

    @NotNull
    private static Set<String> blacklist(@NotNull Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider != null) {
            ParameterNameHintsSettings settings = ParameterNameHintsSettings.getInstance();
            Diff diff = settings.getBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language));
            return diff.applyOn(provider.getDefaultBlackList());
        }
        return Collections.emptySet();
    }
}

