/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TooltipEvent;
import com.intellij.internal.statistic.service.fus.collectors.TooltipActionsLogger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineTooltipRenderer
extends ComparableObject.Impl
implements TooltipRenderer {
    @NonNls
    @Nullable
    protected String myText;
    protected final int myCurrentWidth;

    public LineTooltipRenderer(@Nullable String text, Object @NotNull [] comparable) {
        this(text, 0, comparable);
    }

    public LineTooltipRenderer(@Nullable String text, int width, Object @NotNull [] comparable) {
        super(comparable);
        this.myCurrentWidth = width;
        this.myText = text;
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull HintHint hintHint, final @NotNull JScrollPane pane2, final @NotNull JEditorPane editorPane, boolean highlightActions, boolean hasSeparators) {
        final int leftBorder = 10;
        final int rightBorder = 12;
        class MyPanel
        extends JPanel
        implements WidthBasedLayout {
            MyPanel() {
                super(new GridBagLayout());
            }

            public int getPreferredWidth() {
                return this.getPreferredSize().width;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getPreferredHeight(int width) {
                int height;
                Dimension size = editorPane.getSize();
                int editorPaneInsets = leftBorder + rightBorder + this.getSideComponentWidth();
                editorPane.setSize(width - editorPaneInsets, Math.max(1, size.height));
                try {
                    JScrollBar scrollBar;
                    height = this.getPreferredSize().height;
                    if (width - editorPaneInsets < editorPane.getMinimumSize().width && (scrollBar = pane2.getHorizontalScrollBar()) != null) {
                        height += scrollBar.getPreferredSize().height;
                    }
                }
                finally {
                    editorPane.setSize(size);
                }
                return height;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return new AccessibleContextDelegate(editorPane.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }
                };
            }

            private int getSideComponentWidth() {
                GridBagLayout layout = (GridBagLayout)this.getLayout();
                Component sideComponent = null;
                GridBagConstraints sideComponentConstraints = null;
                boolean unsupportedLayout = false;
                for (Component component2 : this.getComponents()) {
                    GridBagConstraints c = layout.getConstraints(component2);
                    if (c.gridx <= 0) continue;
                    if (sideComponent == null && c.gridy == 0) {
                        sideComponent = component2;
                        sideComponentConstraints = c;
                        continue;
                    }
                    unsupportedLayout = true;
                }
                if (unsupportedLayout) {
                    Logger.getInstance(LineTooltipRenderer.class).error("Unsupported tooltip layout");
                }
                if (sideComponent == null) {
                    return 0;
                }
                Insets insets = sideComponentConstraints.insets;
                return sideComponent.getPreferredSize().width + (insets == null ? 0 : insets.left + insets.right);
            }
        }
        MyPanel grid = new MyPanel();
        GridBag bag = new GridBag().anchor(10).weightx(1.0).weighty(1.0).fillCell();
        pane2.setBorder((Border)JBUI.Borders.empty((int)10, (int)leftBorder, (int)(highlightActions ? 10 : (hasSeparators ? 8 : 3)), (int)rightBorder));
        grid.add((Component)pane2, bag);
        grid.setBackground(hintHint.getTextBackground());
        grid.setBorder((Border)JBUI.Borders.empty());
        grid.setOpaque(hintHint.isOpaqueAllowed());
        return grid;
    }

    @Override
    public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        LightweightHint hint = this.createHint(editor, p, alignToRight, group, hintHint, true, true, null);
        if (hint != null) {
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, p, 58, 0, false, hintHint);
        }
        return hint;
    }

    public LightweightHint createHint(final @NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint, boolean highlightActions, boolean limitWidthToScreen, @Nullable TooltipReloader tooltipReloader) {
        if (this.myText == null) {
            return null;
        }
        String tooltipPreText = this.myText.replaceAll(String.valueOf('\u001b'), "");
        String dressedText = this.dressDescription(editor, tooltipPreText, this.myCurrentWidth > 0);
        final boolean expanded = this.myCurrentWidth > 0 && !dressedText.equals(tooltipPreText);
        final JComponent contentComponent = editor.getContentComponent();
        JComponent editorComponent = editor.getComponent();
        if (!editorComponent.isShowing()) {
            return null;
        }
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        String textToDisplay = LineTooltipRenderer.colorizeSeparators(dressedText);
        final JEditorPane editorPane = IdeTooltipManager.initPane(new Html(textToDisplay).setKeepFont(true), hintHint, layeredPane, limitWidthToScreen);
        UIUtil.enableEagerSoftWrapping((JTextComponent)editorPane);
        editorPane.putClientProperty(UIUtil.TEXT_COPY_ROOT, Boolean.TRUE);
        hintHint.setContentActive(this.isContentAction(dressedText));
        if (!hintHint.isAwtTooltip()) {
            LineTooltipRenderer.correctLocation(editor, editorPane, p, alignToRight, expanded, this.myCurrentWidth);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)editorPane, (boolean)true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.getViewport().setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.setBackground(hintHint.getTextBackground());
        scrollPane.getViewport().setBackground(hintHint.getTextBackground());
        scrollPane.setViewportBorder(null);
        if (hintHint.isRequestFocus()) {
            editorPane.setFocusable(true);
        }
        final ArrayList<ReloadHintAction> actions = new ArrayList<ReloadHintAction>();
        JPanel grid = LineTooltipRenderer.createMainPanel(hintHint, scrollPane, editorPane, highlightActions, !textToDisplay.equals(dressedText));
        if (ScreenReader.isActive()) {
            grid.setFocusTraversalPolicyProvider(true);
            grid.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return editorPane;
                }

                @Override
                public boolean getImplicitDownCycleTraversal() {
                    return true;
                }
            });
        }
        final LightweightHint hint = new LightweightHint(grid){

            @Override
            public void hide() {
                super.hide();
                for (AnAction action2 : actions) {
                    action2.unregisterCustomShortcutSet(contentComponent);
                }
            }

            @Override
            protected boolean canAutoHideOn(TooltipEvent event) {
                if (!LineTooltipRenderer.this.canAutoHideOn(event)) {
                    return false;
                }
                return super.canAutoHideOn(event);
            }
        };
        final TooltipReloader reloader = tooltipReloader == null ? toExpand -> this.reloadFor(hint, editor, p, editorPane, alignToRight, group, hintHint, toExpand) : tooltipReloader;
        ReloadHintAction reloadAction = new ReloadHintAction(hintHint, reloader, expanded);
        reloadAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowErrorDescription"), contentComponent);
        actions.add(reloadAction);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                        hint.hide();
                        return;
                    }
                    String description = e.getDescription();
                    if (description != null && LineTooltipRenderer.handle(description, editor)) {
                        hint.hide();
                        return;
                    }
                    TooltipActionsLogger.logShowDescription((Project)editor.getProject(), (TooltipActionsLogger.Source)TooltipActionsLogger.Source.MoreLink, (InputEvent)e.getInputEvent(), null);
                    reloader.reload(!expanded);
                }
            }
        });
        this.fillPanel(editor, grid, hint, hintHint, actions, reloader, highlightActions);
        return hint;
    }

    @NotNull
    private static String colorizeSeparators(@NotNull String html) {
        String body = UIUtil.getHtmlBody((String)html);
        List parts = StringUtil.split((String)body, (String)"<hr size=1 noshade>", (boolean)true, (boolean)false);
        if (parts.size() <= 1) {
            return html;
        }
        StringBuilder b = new StringBuilder();
        for (String part : parts) {
            boolean addBorder = b.length() > 0;
            b.append("<div");
            if (addBorder) {
                b.append(" style='margin-top:6; padding-top:6; border-top: thin solid #");
                b.append(ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor()));
                b.append("'");
            }
            b.append("'>").append(part).append("</div>");
        }
        return XmlStringUtil.wrapInHtml((CharSequence)b.toString());
    }

    protected boolean isContentAction(String dressedText) {
        return LineTooltipRenderer.isActiveHtml(dressedText);
    }

    protected boolean canAutoHideOn(@NotNull TooltipEvent event) {
        return true;
    }

    private void reloadFor(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @NotNull JComponent pane2, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint, boolean expand) {
        hint.hide();
        hintHint.setShowImmediately(true);
        Point point = new Point(p);
        TooltipController.getInstance().showTooltip(editor, point, this.createRenderer(this.myText, expand ? pane2.getWidth() : 0), alignToRight, group, hintHint);
    }

    protected void fillPanel(@NotNull Editor editor, @NotNull JPanel component2, @NotNull LightweightHint hint, @NotNull HintHint hintHint, @NotNull List<? super AnAction> actions, @NotNull TooltipReloader expandCallback, boolean highlightActions) {
        hintHint.setComponentBorder((Border)JBUI.Borders.empty());
        hintHint.setBorderInsets((Insets)JBUI.insets((int)0));
    }

    private static boolean handle(@NotNull String ref, @NotNull Editor editor) {
        return TooltipLinkHandlerEP.handleLink(ref, editor);
    }

    public static void correctLocation(Editor editor, JComponent tooltipComponent, Point p, boolean alignToRight, boolean expanded, int currentWidth) {
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        int widthLimit = layeredPane.getWidth() - 10;
        int heightLimit = layeredPane.getHeight() - 5;
        Dimension dimension = LineTooltipRenderer.correctLocation(editor, p, alignToRight, expanded, tooltipComponent, layeredPane, widthLimit, heightLimit, currentWidth);
        tooltipComponent.setSize(dimension);
        tooltipComponent.setMaximumSize(dimension);
        tooltipComponent.setMinimumSize(dimension);
        tooltipComponent.setPreferredSize(dimension);
    }

    private static Dimension correctLocation(Editor editor, Point p, boolean alignToRight, boolean expanded, JComponent tooltipComponent, JLayeredPane layeredPane, int widthLimit, int heightLimit, int currentWidth) {
        Dimension preferredSize = tooltipComponent.getPreferredSize();
        int width = expanded ? 3 * currentWidth / 2 : preferredSize.width;
        int height = expanded ? Math.max(preferredSize.height, 150) : preferredSize.height;
        Dimension dimension = new Dimension(width, height);
        if (alignToRight) {
            p.x = Math.max(0, p.x - width);
        }
        p.x += 3;
        p.y += 3;
        if (p.x >= widthLimit - width) {
            p.x = widthLimit - width;
            width = Math.min(width, widthLimit);
            dimension = new Dimension(width, height += 20);
        }
        if (p.x < 3) {
            p.x = 3;
        }
        if (p.y > heightLimit - height) {
            p.y = heightLimit - height;
            height = Math.min(heightLimit, height);
            dimension = new Dimension(width, height);
        }
        if (p.y < 3) {
            p.y = 3;
        }
        LineTooltipRenderer.locateOutsideMouseCursor(editor, layeredPane, p, width, height, heightLimit);
        return dimension;
    }

    private static void locateOutsideMouseCursor(Editor editor, JComponent editorComponent, Point p, int width, int height, int heightLimit) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point mouse = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(mouse, editorComponent);
        Rectangle tooltipRect = new Rectangle(p, new Dimension(width, height));
        tooltipRect.setBounds(tooltipRect.x, tooltipRect.y - editor.getLineHeight(), width, height + 2 * editor.getLineHeight());
        if (tooltipRect.contains(mouse)) {
            p.y = mouse.y + height + editor.getLineHeight() > heightLimit && mouse.y - height - editor.getLineHeight() > 0 ? mouse.y - height - editor.getLineHeight() : mouse.y + editor.getLineHeight();
        }
    }

    @NotNull
    public LineTooltipRenderer createRenderer(@Nullable String text, int width) {
        return new LineTooltipRenderer(text, width, this.getEqualityObjects());
    }

    @NotNull
    protected String dressDescription(@NotNull Editor editor, @NotNull String tooltipText, boolean expanded) {
        return tooltipText;
    }

    protected static boolean isActiveHtml(@NotNull String html) {
        return html.contains("</a>");
    }

    public void addBelow(@NotNull String text) {
        String newBody;
        if (this.myText == null) {
            newBody = UIUtil.getHtmlBody((String)text);
        } else {
            String html1 = UIUtil.getHtmlBody((String)this.myText);
            String html2 = UIUtil.getHtmlBody((String)text);
            newBody = html1 + "<hr size=1 noshade>" + html2;
        }
        this.myText = XmlStringUtil.wrapInHtml((CharSequence)newBody);
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    private static class ReloadHintAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private final HintHint myHintHint;
        private final TooltipReloader myReloader;
        private final boolean myExpanded;

        private ReloadHintAction(HintHint hintHint, TooltipReloader reloader, boolean expanded) {
            this.myHintHint = hintHint;
            this.myReloader = reloader;
            this.myExpanded = expanded;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myHintHint.setRequestFocus(ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent);
            TooltipActionsLogger.logShowDescription((Project)e.getProject(), (TooltipActionsLogger.Source)TooltipActionsLogger.Source.Shortcut, (InputEvent)e.getInputEvent(), (String)e.getPlace());
            this.myReloader.reload(!this.myExpanded);
        }
    }

    @FunctionalInterface
    public static interface TooltipReloader {
        public void reload(boolean var1);
    }
}

