/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ImplementationTextProcessor;
import com.intellij.codeInsight.hint.ImplementationTextSelectioner;
import com.intellij.codeInsight.hint.ImplementationViewDocumentFactory;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.LanguageImplementationTextProcessor;
import com.intellij.codeInsight.hint.LanguageImplementationTextSelectioner;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.usages.UsageView;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementationViewComponent
extends JPanel {
    @NonNls
    private static final String TEXT_PAGE_KEY = "Text";
    @NonNls
    private static final String BINARY_PAGE_KEY = "Binary";
    private final EditorFactory factory;
    private final Project project;
    private ImplementationViewElement[] myElements;
    private int myIndex;
    private EditorEx myEditor;
    private volatile boolean myEditorReleased;
    private final JPanel myViewingPanel;
    private final JLabel myLocationLabel;
    private final JLabel myCountLabel;
    private final CardLayout myBinarySwitch;
    private final JPanel myBinaryPanel;
    private ComboBox<FileDescriptor> myFileChooser;
    private FileEditor myNonTextEditor;
    private FileEditorProvider myCurrentNonTextEditorProvider;
    private JBPopup myHint;
    private String myTitle;
    private final ActionToolbar myToolbar;
    private JLabel myLabel;

    public void setHint(JBPopup hint, @NotNull String title) {
        this.myHint = hint;
        this.myTitle = title;
    }

    public boolean hasElementsToShow() {
        return this.myElements != null && this.myElements.length > 0;
    }

    public ImplementationViewComponent(Collection<ImplementationViewElement> elements2, int index) {
        super(new BorderLayout());
        this.project = elements2.size() > 0 ? elements2.iterator().next().getProject() : null;
        this.factory = EditorFactory.getInstance();
        Document doc = this.factory.createDocument((CharSequence)"");
        doc.setReadOnly(true);
        this.myEditor = (EditorEx)this.factory.createEditor(doc, this.project);
        this.tuneEditor(null);
        this.myBinarySwitch = new CardLayout();
        this.myViewingPanel = new JPanel(this.myBinarySwitch);
        this.myViewingPanel.add((Component)this.myEditor.getComponent(), TEXT_PAGE_KEY);
        this.myBinaryPanel = new JPanel(new BorderLayout());
        this.myViewingPanel.add((Component)this.myBinaryPanel, BINARY_PAGE_KEY);
        this.add((Component)this.myViewingPanel, "Center");
        this.myToolbar = this.createToolbar();
        this.myLocationLabel = new JLabel();
        this.myCountLabel = new JLabel();
        JPanel header2 = new JPanel(new BorderLayout(2, 0));
        header2.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((int)8), (Border)JBUI.Borders.emptyRight((int)5)));
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0);
        toolbarPanel.add((Component)this.myToolbar.getComponent(), gc);
        this.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        ImplementationViewComponent.update(elements2, (PairFunction<ImplementationViewElement[], ? super List<FileDescriptor>, Boolean>)((PairFunction)(psiElements, fileDescriptors) -> {
            if (((ImplementationViewElement[])psiElements).length == 0) {
                return false;
            }
            this.myElements = psiElements;
            this.myIndex = index < this.myElements.length ? index : 0;
            VirtualFile virtualFile = this.myElements[this.myIndex].getContainingFile();
            if (virtualFile != null) {
                EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)virtualFile);
                this.myEditor.setHighlighter(highlighter);
            }
            gc.fill = 2;
            gc.weightx = 1.0;
            this.myLabel = new JLabel();
            this.myFileChooser = new ComboBox((Object[])fileDescriptors.toArray(new FileDescriptor[0]), 250);
            this.myFileChooser.addActionListener(e -> {
                int index1 = this.myFileChooser.getSelectedIndex();
                if (this.myIndex != index1) {
                    this.myIndex = index1;
                    this.updateControls();
                }
            });
            toolbarPanel.add((Component)this.myFileChooser, gc);
            if (this.myElements.length > 1) {
                this.updateRenderer(this.project);
                this.myLabel.setVisible(false);
            } else {
                this.myFileChooser.setVisible(false);
                this.myCountLabel.setVisible(false);
                if (virtualFile != null) {
                    this.myLabel.setIcon(ImplementationViewComponent.getIconForFile(virtualFile, this.project));
                    this.myLabel.setForeground(FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile).getColor());
                    this.myLabel.setText(virtualFile.getPresentableName());
                    this.myLabel.setBorder(new CompoundBorder((Border)IdeBorderFactory.createRoundedBorder(), (Border)JBUI.Borders.emptyRight((int)5)));
                }
                toolbarPanel.add((Component)this.myLabel, gc);
            }
            gc.fill = 0;
            gc.weightx = 0.0;
            toolbarPanel.add((Component)this.myCountLabel, gc);
            header2.add((Component)toolbarPanel, "Center");
            header2.add((Component)this.myLocationLabel, "East");
            this.add((Component)header2, "North");
            this.updateControls();
            return true;
        }));
    }

    private void tuneEditor(VirtualFile virtualFile) {
        this.myEditor.setBackgroundColor(EditorFragmentComponent.getBackgroundColor(this.myEditor));
        EditorSettings settings = this.myEditor.getSettings();
        settings.setAdditionalLinesCount(1);
        settings.setAdditionalColumnsCount(1);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        this.myEditor.setBorder(null);
        this.myEditor.getScrollPane().setViewportBorder((Border)JBScrollPane.createIndentBorder());
        if (virtualFile != null) {
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)virtualFile);
            this.myEditor.setHighlighter(highlighter);
        }
    }

    private void updateRenderer(Project project) {
        this.myFileChooser.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
            VirtualFile file2 = value2.myFile;
            label2.setIcon(ImplementationViewComponent.getIconForFile(file2, project));
            label2.setForeground(FileStatusManager.getInstance((Project)project).getStatus(file2).getColor());
            label2.setText(value2.myPresentableText);
        }));
    }

    public String[] getVisibleFiles() {
        ComboBoxModel model = this.myFileChooser.getModel();
        String[] result2 = new String[model.getSize()];
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            FileDescriptor o = (FileDescriptor)model.getElementAt(i2);
            result2[i2] = o.myPresentableText;
        }
        return result2;
    }

    public void update(@NotNull Collection<? extends ImplementationViewElement> elements2, int index) {
        ImplementationViewComponent.update(elements2, (PairFunction<ImplementationViewElement[], ? super List<FileDescriptor>, Boolean>)((PairFunction)(psiElements, fileDescriptors) -> {
            if (this.myEditor.isDisposed()) {
                return false;
            }
            if (((ImplementationViewElement[])psiElements).length == 0) {
                return false;
            }
            Project project = psiElements[0].getProject();
            this.myElements = psiElements;
            this.myIndex = index < this.myElements.length ? index : 0;
            VirtualFile virtualFile = this.myElements[this.myIndex].getContainingFile();
            if (virtualFile != null) {
                EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
                this.myEditor.setHighlighter(highlighter);
            }
            if (this.myElements.length > 1) {
                this.myFileChooser.setVisible(true);
                this.myCountLabel.setVisible(true);
                this.myLabel.setVisible(false);
                this.myFileChooser.setModel(new DefaultComboBoxModel<FileDescriptor>(fileDescriptors.toArray(new FileDescriptor[0])));
                this.updateRenderer(project);
            } else {
                this.myFileChooser.setVisible(false);
                this.myCountLabel.setVisible(false);
                if (virtualFile != null) {
                    this.myLabel.setIcon(ImplementationViewComponent.getIconForFile(virtualFile, project));
                    this.myLabel.setForeground(FileStatusManager.getInstance((Project)project).getStatus(virtualFile).getColor());
                    this.myLabel.setText(virtualFile.getPresentableName());
                    this.myLabel.setBorder(new CompoundBorder((Border)IdeBorderFactory.createRoundedBorder(), (Border)JBUI.Borders.emptyRight((int)5)));
                    this.myLabel.setVisible(true);
                }
            }
            this.updateControls();
            this.revalidate();
            this.repaint();
            return true;
        }));
    }

    private static void update(@NotNull Collection<? extends ImplementationViewElement> elements2, @NotNull PairFunction<ImplementationViewElement[], ? super List<FileDescriptor>, Boolean> fun) {
        ArrayList<ImplementationViewElement> candidates = new ArrayList<ImplementationViewElement>(elements2.size());
        ArrayList<FileDescriptor> files2 = new ArrayList<FileDescriptor>(elements2.size());
        HashSet<String> names2 = new HashSet<String>();
        for (ImplementationViewElement implementationViewElement : elements2) {
            if (implementationViewElement.isNamed()) {
                names2.add(implementationViewElement.getName());
            }
            if (names2.size() <= 1) continue;
            break;
        }
        for (ImplementationViewElement implementationViewElement : elements2) {
            VirtualFile file2 = implementationViewElement.getContainingFile();
            if (file2 == null) continue;
            if (names2.size() > 1) {
                files2.add(new FileDescriptor(file2, implementationViewElement));
            } else {
                files2.add(new FileDescriptor(file2, implementationViewElement.getContainingMemberOrSelf()));
            }
            candidates.add(implementationViewElement);
        }
        fun.fun((Object)candidates.toArray(new ImplementationViewElement[0]), files2);
    }

    private static Icon getIconForFile(VirtualFile virtualFile, Project project) {
        return IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)project);
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myElements.length > 1 ? this.myFileChooser : this.myEditor.getContentComponent();
    }

    private void updateControls() {
        this.updateLabels();
        this.updateCombo();
        this.updateEditorText();
        this.myToolbar.updateActionsImmediately();
    }

    private void updateCombo() {
        if (this.myFileChooser != null && this.myFileChooser.isVisible()) {
            this.myFileChooser.setSelectedIndex(this.myIndex);
        }
    }

    private void updateEditorText() {
        FileEditorProvider[] providers;
        this.disposeNonTextEditor();
        ImplementationViewElement foundElement = this.myElements[this.myIndex];
        Project project = foundElement.getProject();
        VirtualFile vFile = foundElement.getContainingFile();
        if (vFile == null) {
            return;
        }
        for (ImplementationViewDocumentFactory documentFactory : (ImplementationViewDocumentFactory[])ImplementationViewDocumentFactory.EP_NAME.getExtensions()) {
            Document document = documentFactory.createDocument(foundElement);
            if (document == null) continue;
            this.replaceEditor(project, vFile, documentFactory, document);
            return;
        }
        for (FileEditorProvider provider : providers = FileEditorProviderManager.getInstance().getProviders(project, vFile)) {
            if (provider instanceof QuickDefinitionProvider) {
                this.updateTextElement(foundElement);
                this.myBinarySwitch.show(this.myViewingPanel, TEXT_PAGE_KEY);
                break;
            }
            if (!provider.accept(project, vFile)) continue;
            this.myCurrentNonTextEditorProvider = provider;
            this.myNonTextEditor = this.myCurrentNonTextEditorProvider.createEditor(project, vFile);
            this.myBinaryPanel.removeAll();
            this.myBinaryPanel.add(this.myNonTextEditor.getComponent());
            this.myBinarySwitch.show(this.myViewingPanel, BINARY_PAGE_KEY);
            break;
        }
    }

    private void replaceEditor(Project project, VirtualFile vFile, ImplementationViewDocumentFactory documentFactory, Document document) {
        this.myViewingPanel.remove(this.myEditor.getComponent());
        this.factory.releaseEditor((Editor)this.myEditor);
        this.myEditor = (EditorEx)this.factory.createEditor(document, project);
        this.tuneEditor(vFile);
        documentFactory.tuneEditorBeforeShow(this.myEditor);
        this.myViewingPanel.add((Component)this.myEditor.getComponent(), TEXT_PAGE_KEY);
        this.myBinarySwitch.show(this.myViewingPanel, TEXT_PAGE_KEY);
        documentFactory.tuneEditorAfterShow(this.myEditor);
    }

    private void disposeNonTextEditor() {
        if (this.myNonTextEditor != null) {
            this.myCurrentNonTextEditorProvider.disposeEditor(this.myNonTextEditor);
            this.myNonTextEditor = null;
            this.myCurrentNonTextEditorProvider = null;
        }
    }

    private void updateTextElement(ImplementationViewElement elt) {
        String newText = elt.getText();
        if (newText == null || Comparing.strEqual((String)newText, (String)this.myEditor.getDocument().getText())) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            DocumentEx fragmentDoc = this.myEditor.getDocument();
            fragmentDoc.setReadOnly(false);
            fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), newText);
            fragmentDoc.setReadOnly(true);
            PsiElement element2 = elt.getElementForShowUsages();
            PsiFile file2 = element2 == null ? null : element2.getContainingFile();
            this.myEditor.getSettings().setTabSize(file2 != null ? CodeStyle.getIndentOptions((PsiFile)file2).TAB_SIZE : CodeStyle.getSettings((Project)elt.getProject()).getTabSize(null));
            this.myEditor.getCaretModel().moveToOffset(0);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        });
    }

    @Nullable
    public static String getNewText(PsiElement elt) {
        int end;
        Project project = elt.getProject();
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(elt);
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        if (elt.getTextRange() == null) {
            return null;
        }
        ImplementationTextSelectioner implementationTextSelectioner = (ImplementationTextSelectioner)LanguageImplementationTextSelectioner.INSTANCE.forLanguage(elt.getLanguage());
        int start2 = implementationTextSelectioner.getTextStartOffset(elt);
        CharSequence rawDefinition = doc.getCharsSequence().subSequence(start2, end);
        for (end = implementationTextSelectioner.getTextEndOffset(elt); end > start2 && StringUtil.isLineBreak((char)rawDefinition.charAt(end - start2 - 1)); --end) {
        }
        int lineStart = doc.getLineStartOffset(doc.getLineNumber(start2));
        int lineEnd = end < doc.getTextLength() ? doc.getLineEndOffset(doc.getLineNumber(end)) : doc.getTextLength();
        String text = doc.getCharsSequence().subSequence(lineStart, lineEnd).toString();
        ImplementationTextProcessor processor2 = (ImplementationTextProcessor)LanguageImplementationTextProcessor.INSTANCE.forLanguage(elt.getLanguage());
        return processor2 != null ? processor2.process(text, elt) : text;
    }

    private static PsiFile getContainingFile(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return psiFile.getOriginalFile();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this) && !this.myEditorReleased) {
            this.myEditorReleased = true;
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            this.disposeNonTextEditor();
        }
    }

    private void updateLabels() {
        this.myLocationLabel.setText(this.myElements[this.myIndex].getLocationText());
        this.myLocationLabel.setIcon(this.myElements[this.myIndex].getLocationIcon());
        this.myCountLabel.setText(CodeInsightBundle.message((String)"n.of.m", (Object[])new Object[]{this.myIndex + 1, this.myElements.length}));
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        BackAction back = new BackAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), this);
        group.add((AnAction)back);
        ForwardAction forward = new ForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), this);
        group.add((AnAction)forward);
        EditSourceActionBase edit = new EditSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getEditSource(), CommonShortcuts.ENTER}), this);
        group.add((AnAction)edit);
        edit = new ShowSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getViewSource(), CommonShortcuts.CTRL_ENTER}), this);
        group.add((AnAction)edit);
        return ActionManager.getInstance().createActionToolbar("ImplementationView", (ActionGroup)group, true);
    }

    private void goBack() {
        --this.myIndex;
        this.updateControls();
    }

    private void goForward() {
        ++this.myIndex;
        this.updateControls();
    }

    public int getIndex() {
        return this.myIndex;
    }

    public ImplementationViewElement[] getElements() {
        return this.myElements;
    }

    public UsageView showInUsageView() {
        return FindUtil.showInUsageView(null, this.collectElementsForShowUsages(), this.myTitle, this.myEditor.getProject());
    }

    private PsiElement[] collectElementsForShowUsages() {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (ImplementationViewElement element2 : this.myElements) {
            PsiElement psiElement = element2.getElementForShowUsages();
            if (psiElement == null) continue;
            result2.add(psiElement);
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    private class EditSourceActionBase
    extends AnAction {
        private final boolean myFocusEditor;

        EditSourceActionBase(boolean focusEditor, Icon icon2, String text) {
            super(text, null, icon2);
            this.myFocusEditor = focusEditor;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(ImplementationViewComponent.this.myFileChooser == null || !ImplementationViewComponent.this.myFileChooser.isPopupVisible());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ImplementationViewComponent.this.myElements[ImplementationViewComponent.this.myIndex].navigate(this.myFocusEditor);
        }
    }

    private class ShowSourceAction
    extends EditSourceActionBase
    implements HintManagerImpl.ActionToIgnore {
        ShowSourceAction() {
            super(false, AllIcons.Actions.Preview, CodeInsightBundle.message((String)"quick.definition.show.source", (Object[])new Object[0]));
        }
    }

    private class EditSourceAction
    extends EditSourceActionBase {
        EditSourceAction() {
            super(true, AllIcons.Actions.EditSource, CodeInsightBundle.message((String)"quick.definition.edit.source", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            super.actionPerformed(e);
            if (ImplementationViewComponent.this.myHint.isVisible()) {
                ImplementationViewComponent.this.myHint.cancel();
            }
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ForwardAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.forward", (Object[])new Object[0]), AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ImplementationViewComponent.this.goForward();
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(ImplementationViewComponent.this.myElements != null && ImplementationViewComponent.this.myIndex < ImplementationViewComponent.this.myElements.length - 1);
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        BackAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.back", (Object[])new Object[0]), AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ImplementationViewComponent.this.goBack();
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(ImplementationViewComponent.this.myIndex > 0);
        }
    }

    private static class FileDescriptor {
        @NotNull
        public final VirtualFile myFile;
        @NotNull
        public final String myPresentableText;

        FileDescriptor(@NotNull VirtualFile file2, ImplementationViewElement element2) {
            this.myFile = file2;
            this.myPresentableText = element2.getPresentableText();
        }
    }
}

