/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CodeBlockSupportHandler {
    public static final LanguageExtension<CodeBlockSupportHandler> EP = new LanguageExtension("com.intellij.codeBlockSupportHandler");

    @NotNull
    public List<TextRange> getCodeBlockMarkerRanges(@NotNull PsiElement var1);

    @NotNull
    public TextRange getCodeBlockRange(@NotNull PsiElement var1);

    @NotNull
    public static TextRange findCodeBlockRange(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        int offset = TargetElementUtil.adjustOffset(psiFile, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement contextElement = psiFile.findElementAt(offset);
        if (contextElement == null) {
            return TextRange.EMPTY_RANGE;
        }
        return EP.allForLanguage(contextElement.getLanguage()).stream().map(handler2 -> handler2.getCodeBlockRange(contextElement)).filter(codeBlockRange -> !codeBlockRange.isEmpty()).findFirst().orElse(TextRange.EMPTY_RANGE);
    }

    @NotNull
    public static List<TextRange> findMarkersRanges(@Nullable PsiElement markerPsiElement) {
        if (markerPsiElement == null) {
            return Collections.emptyList();
        }
        for (CodeBlockSupportHandler handler2 : EP.allForLanguage(markerPsiElement.getLanguage())) {
            List<TextRange> rangesToHighlight = handler2.getCodeBlockMarkerRanges(markerPsiElement);
            if (rangesToHighlight.isEmpty()) continue;
            return rangesToHighlight;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<TextRange> findMarkersRanges(@Nullable PsiFile psiFile, @NotNull Language language, int offset) {
        if (psiFile == null) {
            return Collections.emptyList();
        }
        return CodeBlockSupportHandler.findMarkersRanges(psiFile.getViewProvider().findElementAt(offset, language));
    }
}

