/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DocumentFoldingInfo
implements CodeFoldingState {
    private static final Logger LOG = Logger.getInstance(DocumentFoldingInfo.class);
    private static final Key<FoldingInfo> FOLDING_INFO_KEY = Key.create((String)"FOLDING_INFO");
    @NotNull
    private final Project myProject;
    private final VirtualFile myFile;
    @NotNull
    private final List<Info> myInfos = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final List<RangeMarker> myRangeMarkers = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "ph";

    DocumentFoldingInfo(@NotNull Project project, @NotNull Document document) {
        this.myProject = project;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
    }

    void loadFromEditor(@NotNull Editor editor) {
        FoldRegion[] foldRegions;
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(!editor.isDisposed());
        this.clear();
        for (FoldRegion region : foldRegions = editor.getFoldingModel().getAllFoldRegions()) {
            boolean collapseByDefault;
            if (!region.isValid() || region.shouldNeverExpand()) continue;
            boolean expanded = region.isExpanded();
            String signature = (String)region.getUserData(UpdateFoldRegionsOperation.SIGNATURE);
            if (signature == "no signature") continue;
            Boolean storedCollapseByDefault = (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
            boolean bl = collapseByDefault = storedCollapseByDefault != null && storedCollapseByDefault != false && !FoldingUtil.caretInsideRange(editor, TextRange.create((Segment)region));
            if (collapseByDefault != expanded && signature != null) continue;
            if (signature != null) {
                this.myInfos.add(new Info(signature, expanded));
                continue;
            }
            RangeMarker marker = editor.getDocument().createRangeMarker(region.getStartOffset(), region.getEndOffset());
            this.myRangeMarkers.add(marker);
            marker.putUserData(FOLDING_INFO_KEY, (Object)new FoldingInfo(region.getPlaceholderText(), expanded));
        }
    }

    @Override
    public void setToEditor(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.myFile);
        if (psiFile == null) {
            return;
        }
        Map<PsiElement, FoldingDescriptor> ranges = null;
        for (Info info : this.myInfos) {
            TextRange range2;
            FoldRegion region;
            FoldingDescriptor descriptor2;
            PsiElement element2 = FoldingPolicy.restoreBySignature(psiFile, info.signature);
            if (element2 == null || !element2.isValid()) continue;
            if (ranges == null) {
                ranges = DocumentFoldingInfo.buildRanges(editor, psiFile);
            }
            if ((descriptor2 = (FoldingDescriptor)ranges.get(element2)) == null || (region = FoldingUtil.findFoldRegion(editor, (range2 = descriptor2.getRange()).getStartOffset(), range2.getEndOffset())) == null) continue;
            region.setExpanded(info.expanded);
        }
        for (RangeMarker marker : this.myRangeMarkers) {
            if (!marker.isValid() || marker.getStartOffset() == marker.getEndOffset()) continue;
            FoldRegion region = FoldingUtil.findFoldRegion(editor, marker.getStartOffset(), marker.getEndOffset());
            FoldingInfo info = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (region == null) {
                if (info != null) {
                    region = editor.getFoldingModel().addFoldRegion(marker.getStartOffset(), marker.getEndOffset(), info.placeHolder);
                }
                if (region == null) {
                    return;
                }
            }
            boolean state = info != null && info.expanded;
            region.setExpanded(state);
        }
    }

    @NotNull
    private static Map<PsiElement, FoldingDescriptor> buildRanges(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        FileASTNode node = psiFile.getNode();
        if (node == null) {
            return Collections.emptyMap();
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiFile, (Document)editor.getDocument(), (boolean)true);
        HashMap<PsiElement, FoldingDescriptor> ranges = new HashMap<PsiElement, FoldingDescriptor>();
        for (FoldingDescriptor descriptor2 : descriptors) {
            ASTNode ast = descriptor2.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges.put(psi, descriptor2);
        }
        return ranges;
    }

    void clear() {
        this.myInfos.clear();
        for (RangeMarker marker : this.myRangeMarkers) {
            marker.dispose();
        }
        this.myRangeMarkers.clear();
    }

    void writeExternal(@NotNull Element element2) {
        if (this.myInfos.isEmpty() && this.myRangeMarkers.isEmpty()) {
            return;
        }
        for (Info info : this.myInfos) {
            Element e = new Element(ELEMENT_TAG);
            e.setAttribute(SIGNATURE_ATT, info.signature);
            if (info.expanded) {
                e.setAttribute(EXPANDED_ATT, Boolean.toString(true));
            }
            element2.addContent(e);
        }
        String date = null;
        for (RangeMarker marker : this.myRangeMarkers) {
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if (date.isEmpty()) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
            String signature = marker.getStartOffset() + ":" + marker.getEndOffset();
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = fi == null ? DEFAULT_PLACEHOLDER : fi.placeHolder;
            e.setAttribute(PLACEHOLDER_ATT, XmlStringUtil.escapeIllegalXmlChars((String)placeHolderText));
            element2.addContent(e);
        }
    }

    void readExternal(Element element2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.clear();
            if (!this.myFile.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
            if (document == null) {
                return;
            }
            String date = null;
            for (Element e : element2.getChildren()) {
                String signature = e.getAttributeValue(SIGNATURE_ATT);
                if (signature == null) continue;
                boolean expanded = Boolean.parseBoolean(e.getAttributeValue(EXPANDED_ATT));
                if (ELEMENT_TAG.equals(e.getName())) {
                    this.myInfos.add(new Info(signature, expanded));
                    continue;
                }
                if (MARKER_TAG.equals(e.getName())) {
                    if (date == null) {
                        date = this.getTimeStamp();
                    }
                    if (date.isEmpty() || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(signature, ":");
                    try {
                        int start2 = Integer.valueOf(tokenizer.nextToken());
                        int end = Integer.valueOf(tokenizer.nextToken());
                        if (start2 < 0 || end >= document.getTextLength() || start2 > end) continue;
                        RangeMarker marker = document.createRangeMarker(start2, end);
                        this.myRangeMarkers.add(marker);
                        String placeholderAttributeValue = e.getAttributeValue(PLACEHOLDER_ATT);
                        String placeHolderText = placeholderAttributeValue == null ? DEFAULT_PLACEHOLDER : XmlStringUtil.unescapeIllegalXmlChars((String)placeholderAttributeValue);
                        FoldingInfo fi = new FoldingInfo(placeHolderText, expanded);
                        marker.putUserData(FOLDING_INFO_KEY, (Object)fi);
                    }
                    catch (NoSuchElementException exc) {
                        LOG.error((Throwable)exc);
                    }
                    continue;
                }
                throw new IllegalStateException("unknown tag: " + e.getName());
            }
        });
    }

    private String getTimeStamp() {
        if (!this.myFile.isValid()) {
            return "";
        }
        return Long.toString(this.myFile.getTimeStamp());
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.myInfos.hashCode();
        result2 = 31 * result2 + this.myRangeMarkers.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFoldingInfo info = (DocumentFoldingInfo)o;
        if (this.myFile != null ? !this.myFile.equals(info.myFile) : info.myFile != null) {
            return false;
        }
        if (!this.myProject.equals(info.myProject) || !this.myInfos.equals(info.myInfos)) {
            return false;
        }
        if (this.myRangeMarkers.size() != info.myRangeMarkers.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myRangeMarkers.size(); ++i2) {
            FoldingInfo ofi;
            RangeMarker other;
            RangeMarker marker = this.myRangeMarkers.get(i2);
            if (marker == (other = info.myRangeMarkers.get(i2)) || !marker.isValid() || !other.isValid()) continue;
            if (!TextRange.areSegmentsEqual((Segment)marker, (Segment)other)) {
                return false;
            }
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (Comparing.equal((Object)fi, (Object)(ofi = (FoldingInfo)other.getUserData(FOLDING_INFO_KEY)))) continue;
            return false;
        }
        return true;
    }

    private static class FoldingInfo {
        private final String placeHolder;
        private final boolean expanded;

        private FoldingInfo(@NotNull String placeHolder, boolean expanded) {
            this.placeHolder = placeHolder;
            this.expanded = expanded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FoldingInfo info = (FoldingInfo)o;
            return this.expanded == info.expanded && this.placeHolder.equals(info.placeHolder);
        }

        public int hashCode() {
            int result2 = this.placeHolder.hashCode();
            result2 = 31 * result2 + (this.expanded ? 1 : 0);
            return result2;
        }

        public boolean getExpanded() {
            return this.expanded;
        }
    }

    private static class Info {
        private final String signature;
        private final boolean expanded;

        Info(@NotNull String signature, boolean expanded) {
            this.signature = signature;
            this.expanded = expanded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return this.expanded == info.expanded && Objects.equals(this.signature, info.signature);
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.expanded);
        }
    }
}

