/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveLeftRight;

import com.intellij.codeInsight.editorActions.moveLeftRight.MoveElementLeftRightHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorLastActionTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveElementLeftRightActionHandler
extends EditorWriteActionHandler {
    private static final Comparator<PsiElement> BY_OFFSET = Comparator.comparingInt(PsiElement::getTextOffset);
    private static final Set<String> OUR_ACTIONS = ContainerUtil.set((Object[])new String[]{"MoveElementLeft", "MoveElementRight"});
    private final boolean myIsLeft;

    public MoveElementLeftRightActionHandler(boolean isLeft) {
        super(true);
        this.myIsLeft = isLeft;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Document document = editor.getDocument();
        if (!(document instanceof DocumentEx)) {
            return false;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return false;
        }
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, caret.getSelectionStart(), caret.getSelectionEnd());
        return elementList != null;
    }

    private static PsiElement @Nullable [] getElementList(@NotNull PsiFile file2, int rangeStart, int rangeEnd) {
        PsiElement startElement = file2.findElementAt(rangeStart);
        if (startElement == null) {
            return null;
        }
        if (rangeEnd > rangeStart) {
            PsiElement endElement = file2.findElementAt(rangeEnd - 1);
            if (endElement == null) {
                return null;
            }
            PsiElement element2 = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            return MoveElementLeftRightActionHandler.getElementList(element2, rangeStart, rangeEnd);
        }
        PsiElement[] list2 = MoveElementLeftRightActionHandler.getElementList(startElement, rangeStart, rangeStart);
        if (list2 != null || rangeStart <= 0) {
            return list2;
        }
        startElement = file2.findElementAt(rangeStart - 1);
        if (startElement == null) {
            return null;
        }
        return MoveElementLeftRightActionHandler.getElementList(startElement, rangeStart, rangeStart);
    }

    private static PsiElement @Nullable [] getElementList(PsiElement element2, int rangeStart, int rangeEnd) {
        while (element2 != null) {
            List handlers = MoveElementLeftRightHandler.EXTENSION.allForLanguageOrAny(element2.getLanguage());
            for (MoveElementLeftRightHandler handler2 : handlers) {
                PsiElement[] elementList = handler2.getMovableSubElements(element2);
                if (elementList.length <= 1) continue;
                PsiElement[] elements2 = (PsiElement[])elementList.clone();
                Arrays.sort(elements2, BY_OFFSET);
                PsiElement first = elements2[0];
                PsiElement last = elements2[elements2.length - 1];
                if (rangeStart < first.getTextRange().getStartOffset() || rangeEnd > last.getTextRange().getEndOffset() || rangeStart < first.getTextRange().getEndOffset() && rangeEnd > last.getTextRange().getStartOffset()) continue;
                return elements2;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        int caretShift;
        assert (caret != null);
        DocumentEx document = (DocumentEx)editor.getDocument();
        Project project = editor.getProject();
        assert (project != null);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file2 = psiDocumentManager.getPsiFile((Document)document);
        assert (file2 != null);
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        assert (selectionStart <= selectionEnd);
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, selectionStart, selectionEnd);
        assert (elementList != null);
        Range<Integer> elementRange = this.findRangeOfElementsToMove(elementList, selectionStart, selectionEnd);
        if (elementRange == null) {
            return;
        }
        if (!OUR_ACTIONS.contains(EditorLastActionTracker.getInstance().getLastActionId())) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("move.element.left.right");
        }
        int toMoveStart = elementList[(Integer)elementRange.getFrom()].getTextRange().getStartOffset();
        int toMoveEnd = elementList[(Integer)elementRange.getTo()].getTextRange().getEndOffset();
        int otherIndex = this.myIsLeft ? (Integer)elementRange.getFrom() - 1 : (Integer)elementRange.getTo() + 1;
        int otherStart = elementList[otherIndex].getTextRange().getStartOffset();
        int otherEnd = elementList[otherIndex].getTextRange().getEndOffset();
        selectionStart = MoveElementLeftRightActionHandler.trim(selectionStart, toMoveStart, toMoveEnd);
        selectionEnd = MoveElementLeftRightActionHandler.trim(selectionEnd, toMoveStart, toMoveEnd);
        int caretOffset = MoveElementLeftRightActionHandler.trim(caret.getOffset(), toMoveStart, toMoveEnd);
        if (toMoveStart < otherStart) {
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            document.moveText(otherStart, otherEnd, toMoveStart);
            caretShift = otherEnd - toMoveEnd;
        } else {
            document.moveText(otherStart, otherEnd, toMoveStart);
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            caretShift = otherStart - toMoveStart;
        }
        caret.moveToOffset(caretOffset + caretShift);
        caret.setSelection(selectionStart + caretShift, selectionEnd + caretShift);
    }

    @Nullable
    private Range<Integer> findRangeOfElementsToMove(PsiElement @NotNull [] elements2, int startOffset, int endOffset) {
        int startIndex = elements2.length;
        int endIndex = -1;
        if (startOffset == endOffset) {
            for (int i2 = 0; i2 < elements2.length; ++i2) {
                if (!elements2[i2].getTextRange().containsOffset(startOffset)) continue;
                startIndex = endIndex = i2;
                break;
            }
        } else {
            int i3 = 0;
            while (i3 < elements2.length) {
                PsiElement psiElement = elements2[i3];
                TextRange range2 = psiElement.getTextRange();
                if (i3 < startIndex && startOffset < range2.getEndOffset()) {
                    startIndex = i3;
                }
                if (endOffset > range2.getStartOffset()) {
                    endIndex = i3++;
                    continue;
                }
                break;
            }
        }
        return startIndex > endIndex || (this.myIsLeft ? startIndex == 0 : endIndex == elements2.length - 1) ? null : new Range((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(endIndex));
    }

    private static int trim(int offset, int rangeStart, int rangeEnd) {
        return Math.max(rangeStart, Math.min(rangeEnd, offset));
    }
}

