/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInCommentUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final String WHITESPACE = " \t";

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        CodeDocumentationAwareCommenter commenter = EnterInCommentUtil.getDocumentationAwareCommenter(dataContext);
        if (commenter == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int lineCommentStartOffset = EnterInLineCommentHandler.getLineCommentStartOffset(editor, caretOffset, commenter);
        if (lineCommentStartOffset < 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        CharSequence text = document.getImmutableCharSequence();
        int offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)WHITESPACE);
        if (offset >= document.getTextLength() || text.charAt(offset) == '\n') {
            return EnterHandlerDelegate.Result.Continue;
        }
        String prefix = commenter.getLineCommentPrefix();
        assert (prefix != null) : "Line Comment type is set but Line Comment Prefix is null!";
        String prefixTrimmed = prefix.trim();
        int beforeCommentOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineCommentStartOffset - 1), (String)WHITESPACE);
        boolean onlyCommentInCaretLine = beforeCommentOffset < 0 || text.charAt(beforeCommentOffset) == '\n';
        CharSequence spacing = " ";
        if (StringUtil.startsWith((CharSequence)text, (int)offset, (CharSequence)prefix)) {
            int afterPrefix = offset + prefixTrimmed.length();
            if (afterPrefix < document.getTextLength() && text.charAt(afterPrefix) != ' ') {
                document.insertString(afterPrefix, spacing);
            }
            caretOffsetRef.set((Object)offset);
        } else {
            if (onlyCommentInCaretLine) {
                int indentStart = lineCommentStartOffset + prefix.trim().length();
                int indentEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)indentStart, (String)WHITESPACE);
                CharSequence currentLineSpacing = text.subSequence(indentStart, indentEnd);
                if (TodoConfiguration.getInstance().isMultiLine() && EnterInCommentUtil.isTodoText(text, lineCommentStartOffset, caretOffset) && EnterInCommentUtil.isTodoText(text, lineCommentStartOffset, DocumentUtil.getLineEndOffset(lineCommentStartOffset, document))) {
                    spacing = currentLineSpacing + " ";
                } else if (currentLineSpacing.length() > 0) {
                    spacing = currentLineSpacing;
                }
                int textStart = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)WHITESPACE);
                document.deleteString(caretOffset, textStart);
            } else if (text.charAt(caretOffset) == ' ') {
                spacing = "";
            }
            document.insertString(caretOffset, (CharSequence)(prefixTrimmed + spacing));
        }
        if (onlyCommentInCaretLine) {
            caretAdvance.set((Object)(prefixTrimmed.length() + spacing.length()));
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    private static int getLineCommentStartOffset(@NotNull Editor editor, int offset, @NotNull CodeDocumentationAwareCommenter commenter) {
        if (offset < 1) {
            return -1;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator2 = highlighter.createIterator(offset - 1);
        String prefix = commenter.getLineCommentPrefix();
        return iterator2.getTokenType() == commenter.getLineCommentTokenType() && iterator2.getStart() + (prefix == null ? 0 : prefix.length()) <= offset ? iterator2.getStart() : -1;
    }
}

