/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterBetweenBracesDelegate {
    private static final Logger LOG = Logger.getInstance(EnterBetweenBracesDelegate.class);
    static final LanguageExtension<EnterBetweenBracesDelegate> EP_NAME = new LanguageExtension("com.intellij.enterBetweenBracesDelegate");

    public boolean bracesAreInTheSameElement(@NotNull PsiFile file2, @NotNull Editor editor, int lBraceOffset, int rBraceOffset) {
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        return file2.findElementAt(lBraceOffset) == file2.findElementAt(rBraceOffset);
    }

    protected void formatAtOffset(@NotNull PsiFile file2, @NotNull Editor editor, int offset, @Nullable Language language) {
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        try {
            CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent(file2, offset);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isInComment(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        return PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiComment.class) != null;
    }

    protected boolean isBracePair(char lBrace, char rBrace) {
        return lBrace == '(' && rBrace == ')' || lBrace == '{' && rBrace == '}';
    }
}

