/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SelectionQuotingTypedHandler
extends TypedHandlerDelegate {
    private static final ExtensionPointName<UnquotingFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionUnquotingFilter");
    private static final ExtensionPointName<DequotingFilter> OLD_EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionDequotingFilter");

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        char selectedChar;
        String selectedText;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c) && (selectedText = selectionModel.getSelectedText()) != null && selectedText.length() == 1 && SelectionQuotingTypedHandler.isSimilarDelimiters(selectedChar = selectedText.charAt(0), c) && selectedChar != c && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor, selectedText, c) && SelectionQuotingTypedHandler.replaceQuotesBySelected(c, editor, file2, selectionModel, selectedChar)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c) && !StringUtil.isEmpty((String)(selectedText = selectionModel.getSelectedText()))) {
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            if (selectedText.length() > 1) {
                char firstChar = selectedText.charAt(0);
                char lastChar = selectedText.charAt(selectedText.length() - 1);
                if (SelectionQuotingTypedHandler.isSimilarDelimiters(firstChar, c) && lastChar == SelectionQuotingTypedHandler.getMatchingDelimiter(firstChar) && (SelectionQuotingTypedHandler.isQuote(firstChar) || firstChar != c) && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor, selectedText, c) && !SelectionQuotingTypedHandler.containsQuoteInside(selectedText, lastChar)) {
                    selectedText = selectedText.substring(1, selectedText.length() - 1);
                }
            }
            int caretOffset = selectionModel.getSelectionStart();
            char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
            String newText = c + selectedText + c2;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            boolean restoreStickySelection = editor instanceof EditorEx && ((EditorEx)editor).isStickySelection();
            selectionModel.removeSelection();
            editor.getDocument().replaceString(selectionStart, selectionEnd, (CharSequence)newText);
            int startOffset = caretOffset + 1;
            int endOffset = caretOffset + newText.length() - 1;
            int length = editor.getDocument().getTextLength();
            if (endOffset <= length) {
                if (restoreStickySelection) {
                    EditorEx editorEx = (EditorEx)editor;
                    CaretModel caretModel = editorEx.getCaretModel();
                    caretModel.moveToOffset(ltrSelection ? startOffset : endOffset);
                    editorEx.setStickySelection(true);
                    caretModel.moveToOffset(ltrSelection ? endOffset : startOffset);
                } else {
                    if (ltrSelection || editor instanceof EditorWindow) {
                        editor.getSelectionModel().setSelection(startOffset, endOffset);
                    } else {
                        editor.getSelectionModel().setSelection(endOffset, startOffset);
                    }
                    editor.getCaretModel().moveToOffset(ltrSelection ? endOffset : startOffset);
                }
                if (c == '{') {
                    int startOffsetToReformat = startOffset - 1;
                    int endOffsetToReformat = length > endOffset ? endOffset + 1 : endOffset;
                    CodeStyleManager.getInstance((Project)project).reformatText(file2, startOffsetToReformat, endOffsetToReformat);
                }
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.beforeSelectionRemoved(c, project, editor, file2);
    }

    private static boolean containsQuoteInside(String selectedText, char quote) {
        return selectedText.indexOf(quote, 1) != selectedText.length() - 1;
    }

    private static boolean replaceQuotesBySelected(char c, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull SelectionModel selectionModel, char selectedChar) {
        int selectionStart = selectionModel.getSelectionStart();
        for (PsiElement element2 = file2.findElementAt(selectionStart); element2 != null; element2 = element2.getParent()) {
            TextRange textRange = element2.getTextRange();
            if (textRange != null && textRange.getLength() >= 2) {
                Document document;
                CharSequence charsSequence;
                int matchingCharOffset;
                boolean isAtStart;
                boolean bl = isAtStart = textRange.getStartOffset() == selectionStart;
                if ((isAtStart || textRange.getEndOffset() == selectionStart + 1 && SelectionQuotingTypedHandler.isQuote(c)) && (matchingCharOffset = isAtStart ? textRange.getEndOffset() - 1 : textRange.getStartOffset()) < (charsSequence = (document = editor.getDocument()).getCharsSequence()).length()) {
                    boolean otherQuoteMatchesSelected;
                    char matchingChar = charsSequence.charAt(matchingCharOffset);
                    boolean bl2 = isAtStart ? matchingChar == SelectionQuotingTypedHandler.getMatchingDelimiter(selectedChar) : (otherQuoteMatchesSelected = selectedChar == SelectionQuotingTypedHandler.getMatchingDelimiter(matchingChar));
                    if (otherQuoteMatchesSelected && !SelectionQuotingTypedHandler.containsQuoteInside(document.getText(textRange), charsSequence.charAt(textRange.getEndOffset() - 1))) {
                        SelectionQuotingTypedHandler.replaceChar(document, textRange.getStartOffset(), c);
                        char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
                        SelectionQuotingTypedHandler.replaceChar(document, textRange.getEndOffset() - 1, c2);
                        editor.getCaretModel().moveToOffset(selectionModel.getSelectionEnd());
                        selectionModel.removeSelection();
                        return true;
                    }
                }
            }
            if (element2 instanceof PsiFile) break;
        }
        return false;
    }

    public static boolean shouldSkipReplacementOfQuotesOrBraces(PsiFile psiFile, Editor editor, String selectedText, char c) {
        return EP_NAME.getExtensionList().stream().anyMatch(filter2 -> filter2.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c)) || OLD_EP_NAME.getExtensionList().stream().anyMatch(filter2 -> filter2.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c));
    }

    private static char getMatchingDelimiter(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        if (c == '<') {
            return '>';
        }
        return c;
    }

    private static boolean isDelimiter(char c) {
        return SelectionQuotingTypedHandler.isBracket(c) || SelectionQuotingTypedHandler.isQuote(c);
    }

    private static boolean isBracket(char c) {
        return c == '(' || c == '{' || c == '[' || c == '<';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    private static boolean isSimilarDelimiters(char c1, char c2) {
        return SelectionQuotingTypedHandler.isBracket(c1) && SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c1) && SelectionQuotingTypedHandler.isQuote(c2);
    }

    private static void replaceChar(Document document, int offset, char newChar) {
        document.replaceString(offset, offset + 1, (CharSequence)String.valueOf(newChar));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static abstract class DequotingFilter
    extends UnquotingFilter {
    }

    public static abstract class UnquotingFilter {
        public abstract boolean skipReplacementQuotesOrBraces(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull String var3, char var4);
    }
}

