/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.CommentCompleteHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.ide.DataManager;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterHandler
extends BaseEnterHandler {
    private static final Logger LOG = Logger.getInstance(EnterHandler.class);
    private final EditorActionHandler myOriginalHandler;
    private static final Key<Language> CONTEXT_LANGUAGE = Key.create((String)"EnterHandler.Language");

    public EnterHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && !project.isDefault()) {
            PostprocessReformattingAspect.getInstance(project).disablePostprocessFormattingInside(() -> this.executeWriteActionInner(editor, caret, EnterHandler.getExtendedContext(dataContext, project, caret), project));
        } else {
            this.executeWriteActionInner(editor, caret, dataContext, project);
        }
    }

    private void executeWriteActionInner(Editor editor, Caret caret, DataContext dataContext, Project project) {
        EnterHandlerDelegate delegate;
        int offset1;
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (project == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file2 == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        CommandProcessor.getInstance().setCurrentCommandName(CodeInsightBundle.message((String)"command.name.typing", (Object[])new Object[0]));
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text = document.getCharsSequence();
        int length = document.getTextLength();
        if (caretOffset < length && text.charAt(caretOffset) != '\n' && ((offset1 = CharArrayUtil.shiftBackward((CharSequence)text, (int)caretOffset, (String)" \t")) < 0 || text.charAt(offset1) == '\n')) {
            boolean fastProcessEnterInsideIndent = true;
            for (EnterHandlerDelegate delegate2 : EnterHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.invokeInsideIndent(offset1, editor, dataContext)) continue;
                fastProcessEnterInsideIndent = false;
                break;
            }
            if (fastProcessEnterInsideIndent) {
                boolean isEmptyLine;
                int offset2 = CharArrayUtil.shiftForward((CharSequence)text, (int)(offset1 + 1), (String)" \t");
                boolean bl = isEmptyLine = offset2 >= length || text.charAt(offset2) == '\n';
                if (!isEmptyLine) {
                    this.myOriginalHandler.execute(editor, caret, dataContext);
                    return;
                }
            }
        }
        boolean forceIndent = false;
        boolean forceSkipIndent = false;
        Ref caretOffsetRef = new Ref((Object)caretOffset);
        Ref caretAdvanceRef = new Ref((Object)0);
        for (EnterHandlerDelegate delegate3 : EnterHandlerDelegate.EP_NAME.getExtensionList()) {
            EnterHandlerDelegate.Result result2 = delegate3.preprocessEnter(file2, editor, (Ref<Integer>)caretOffsetRef, (Ref<Integer>)caretAdvanceRef, dataContext, this.myOriginalHandler);
            if ((Integer)caretOffsetRef.get() > document.getTextLength()) {
                throw new AssertionError((Object)("Wrong caret offset change by " + delegate3));
            }
            if (result2 == EnterHandlerDelegate.Result.Stop) {
                return;
            }
            if (result2 == EnterHandlerDelegate.Result.Continue) continue;
            if (result2 == EnterHandlerDelegate.Result.DefaultForceIndent) {
                forceIndent = true;
                break;
            }
            if (result2 != EnterHandlerDelegate.Result.DefaultSkipIndent) break;
            forceSkipIndent = true;
            break;
        }
        text = document.getCharsSequence();
        caretOffset = (Integer)caretOffsetRef.get();
        boolean isFirstColumn = caretOffset == 0 || text.charAt(caretOffset - 1) == '\n';
        boolean insertSpace = !isFirstColumn && caretOffset < text.length() && text.charAt(caretOffset) != ' ' && text.charAt(caretOffset) != '\t';
        editor.getCaretModel().moveToOffset(caretOffset);
        this.myOriginalHandler.execute(editor, caret, dataContext);
        if (!editor.isInsertMode() || forceSkipIndent) {
            return;
        }
        if (settings.SMART_INDENT_ON_ENTER || forceIndent) {
            ++caretOffset;
            caretOffset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)caretOffset, (String)" \t");
            if (DocumentUtil.isAtLineEnd(caretOffset, document)) {
                caretOffset = editor.getCaretModel().getOffset();
            }
        } else {
            caretOffset = editor.getCaretModel().getOffset();
        }
        DoEnterAction action2 = new DoEnterAction(file2, editor, document, dataContext, caretOffset, !insertSpace, (Integer)caretAdvanceRef.get(), project);
        action2.setForceIndent(forceIndent);
        action2.run();
        Iterator iterator2 = EnterHandlerDelegate.EP_NAME.getExtensionList().iterator();
        while (iterator2.hasNext() && (delegate = (EnterHandlerDelegate)iterator2.next()).postProcessEnter(file2, editor, dataContext) != EnterHandlerDelegate.Result.Stop) {
        }
        if (settings.SMART_INDENT_ON_ENTER && action2.isIndentAdjustmentNeeded()) {
            CodeStyleManager.getInstance((Project)project).scheduleIndentAdjustment(document, editor.getCaretModel().getOffset());
        }
    }

    @NotNull
    private static DataContext getExtendedContext(@NotNull DataContext originalContext, @NotNull Project project, @NotNull Caret caret) {
        DataContext context = originalContext instanceof UserDataHolder ? originalContext : new DataContextWrapper(originalContext);
        ((UserDataHolder)context).putUserData(CONTEXT_LANGUAGE, (Object)PsiUtilBase.getLanguageInEditor((Caret)caret, (Project)project));
        return context;
    }

    public static boolean isCommentComplete(PsiComment comment, CodeDocumentationAwareCommenter commenter, Editor editor) {
        JavaLikeQuoteHandler javaLikeQuoteHandler;
        String expectedCommentEnd;
        for (CommentCompleteHandler handler2 : CommentCompleteHandler.EP_NAME.getExtensionList()) {
            if (!handler2.isApplicable(comment, commenter)) continue;
            return handler2.isCommentComplete(comment, commenter, editor);
        }
        String commentText = comment.getText();
        boolean docComment = EnterHandler.isDocComment((PsiElement)comment, commenter);
        String string = expectedCommentEnd = docComment ? commenter.getDocumentationCommentSuffix() : commenter.getBlockCommentSuffix();
        if (!commentText.endsWith(expectedCommentEnd)) {
            return false;
        }
        PsiFile containingFile = comment.getContainingFile();
        Language language = containingFile.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            return true;
        }
        Lexer lexer = parserDefinition.createLexer(containingFile.getProject());
        String commentPrefix = docComment ? commenter.getDocumentationCommentPrefix() : commenter.getBlockCommentPrefix();
        lexer.start((CharSequence)commentText, commentPrefix == null ? 0 : commentPrefix.length(), commentText.length());
        QuoteHandler fileTypeHandler = TypedHandler.getQuoteHandler(containingFile, editor);
        JavaLikeQuoteHandler javaLikeQuoteHandler2 = javaLikeQuoteHandler = fileTypeHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeHandler : null;
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (javaLikeQuoteHandler != null && javaLikeQuoteHandler.getStringTokenTypes() != null && javaLikeQuoteHandler.getStringTokenTypes().contains(tokenType)) {
                String text = commentText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                int endOffset = comment.getTextRange().getEndOffset();
                if (text.endsWith(expectedCommentEnd) && endOffset < containingFile.getTextLength() && containingFile.getText().charAt(endOffset) == '\n') {
                    return true;
                }
            }
            if (tokenType == commenter.getDocumentationCommentTokenType() || tokenType == commenter.getBlockCommentTokenType()) {
                return false;
            }
            if (tokenType == commenter.getLineCommentTokenType() && lexer.getTokenText().contains(commentPrefix)) {
                return false;
            }
            if (lexer.getTokenEnd() == commentText.length()) {
                if (tokenType == commenter.getLineCommentTokenType()) {
                    String prefix = commenter.getLineCommentPrefix();
                    lexer.start((CharSequence)commentText, lexer.getTokenStart() + (prefix == null ? 0 : prefix.length()), commentText.length());
                    lexer.advance();
                    continue;
                }
                return !EnterHandler.isInvalidPsi((PsiElement)comment);
            }
            lexer.advance();
        }
        return false;
    }

    private static boolean isInvalidPsi(@NotNull PsiElement base) {
        for (PsiElement current2 = base.getNextSibling(); current2 != null; current2 = current2.getNextSibling()) {
            if (!(current2 instanceof PsiErrorElement)) continue;
            return true;
        }
        return base.getPrevSibling() instanceof PsiErrorElement;
    }

    private static boolean isDocComment(PsiElement element2, CodeDocumentationAwareCommenter commenter) {
        if (!(element2 instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element2;
        return commenter.isDocumentationComment(comment);
    }

    public static int adjustLineIndentNoCommit(Language language, @NotNull Document document, @NotNull Editor editor, int offset) {
        CharSequence docChars = document.getCharsSequence();
        int indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)(offset - 1), (String)"\n") + 1;
        int indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t");
        String newIndent = CodeStyleFacade.getInstance((Project)editor.getProject()).getLineIndent(editor, language, offset, false);
        if (newIndent == null) {
            return -1;
        }
        if (newIndent == LineIndentProvider.DO_NOT_ADJUST) {
            return offset;
        }
        int delta = newIndent.length() - (indentEnd - indentStart);
        document.replaceString(indentStart, indentEnd, (CharSequence)newIndent);
        return offset <= indentEnd ? indentStart + newIndent.length() : offset + delta;
    }

    @Nullable
    public static Language getLanguage(@NotNull DataContext dataContext) {
        if (dataContext instanceof UserDataHolder) {
            return (Language)CONTEXT_LANGUAGE.get((UserDataHolder)dataContext);
        }
        return null;
    }

    private static class DoEnterAction
    implements Runnable {
        private final DataContext myDataContext;
        private final PsiFile myFile;
        private int myOffset;
        private final Document myDocument;
        private final boolean myInsertSpace;
        private final Editor myEditor;
        private final Project myProject;
        private int myCaretAdvance;
        private boolean myForceIndent = false;
        private static final String LINE_SEPARATOR = "\n";
        private boolean myIsIndentAdjustmentNeeded = true;

        DoEnterAction(PsiFile file2, Editor view, Document document, DataContext dataContext, int offset, boolean insertSpace, int caretAdvance, Project project) {
            this.myEditor = view;
            this.myFile = file2;
            this.myDataContext = dataContext;
            this.myOffset = offset;
            this.myDocument = document;
            this.myInsertSpace = insertSpace;
            this.myCaretAdvance = caretAdvance;
            this.myProject = project;
        }

        public void setForceIndent(boolean forceIndent) {
            this.myForceIndent = forceIndent;
        }

        @Override
        public void run() {
            CaretModel caretModel = this.myEditor.getCaretModel();
            try {
                int line;
                PsiElement element2;
                CharSequence chars = this.myDocument.getCharsSequence();
                int i2 = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(this.myOffset - 1), (String)LINE_SEPARATOR) - 1;
                i2 = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)i2, (String)LINE_SEPARATOR) + 1;
                if (i2 < 0) {
                    i2 = 0;
                }
                int lineStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)i2, (String)" \t");
                Language language = this.myDataContext instanceof UserDataHolder ? (Language)CONTEXT_LANGUAGE.get((UserDataHolder)this.myDataContext) : null;
                Commenter langCommenter = language != null ? (Commenter)LanguageCommenters.INSTANCE.forLanguage(language) : null;
                CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(langCommenter, chars, lineStart);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                if (commentContext.docStart) {
                    psiDocumentManager.commitDocument(this.myDocument);
                    element2 = this.myFile.findElementAt(commentContext.lineStart);
                    String text = element2.getText();
                    PsiElement parent = element2.getParent();
                    if (text.equals(commentContext.commenter.getDocumentationCommentPrefix()) && EnterHandler.isDocComment(parent, commentContext.commenter) || text.startsWith(commentContext.commenter.getDocumentationCommentPrefix()) && element2 instanceof PsiComment) {
                        PsiComment comment = EnterHandler.isDocComment(parent, commentContext.commenter) ? (PsiComment)parent : (PsiComment)element2;
                        int commentEnd = comment.getTextRange().getEndOffset();
                        if (this.myOffset >= commentEnd) {
                            commentContext.docStart = false;
                        } else if (EnterHandler.isCommentComplete(comment, commentContext.commenter, this.myEditor)) {
                            commentContext.docAsterisk = this.myOffset >= commentEnd ? false : CodeStyleManager.getInstance((Project)this.getProject()).getDocCommentSettings(this.myFile).isLeadingAsteriskEnabled();
                            commentContext.docStart = false;
                        } else {
                            this.generateJavadoc(commentContext.commenter);
                        }
                    } else {
                        commentContext.docStart = false;
                    }
                } else if (commentContext.docAsterisk) {
                    psiDocumentManager.commitDocument(this.myDocument);
                    element2 = this.myFile.findElementAt(commentContext.lineStart);
                    PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiComment.class, (boolean)false);
                    if (comment == null || !EnterHandler.isDocComment((PsiElement)comment, commentContext.commenter)) {
                        commentContext.docAsterisk = false;
                    }
                }
                String indentInsideJavadoc = null;
                if (this.myOffset < this.myDocument.getTextLength() && (line = this.myDocument.getLineNumber(this.myOffset)) > 0 && (commentContext.docAsterisk || commentContext.docStart)) {
                    indentInsideJavadoc = CodeDocumentationUtil.getIndentInsideJavadoc(this.myDocument, this.myDocument.getLineStartOffset(line - 1));
                }
                if (commentContext.docAsterisk) {
                    commentContext.docAsterisk = this.insertDocAsterisk(commentContext.lineStart, commentContext.docAsterisk, !StringUtil.isEmpty(indentInsideJavadoc), commentContext.commenter);
                }
                boolean docIndentApplied = false;
                CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
                if (codeInsightSettings.SMART_INDENT_ON_ENTER || this.myForceIndent || commentContext.docStart || commentContext.docAsterisk) {
                    int offset = EnterHandler.adjustLineIndentNoCommit(EnterHandler.getLanguage(this.myDataContext), this.myDocument, this.myEditor, this.myOffset);
                    if (offset >= 0) {
                        this.myOffset = offset;
                        this.myIsIndentAdjustmentNeeded = false;
                    }
                    if (commentContext.docAsterisk && !StringUtil.isEmpty((String)indentInsideJavadoc) && this.myOffset < this.myDocument.getTextLength()) {
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)indentInsideJavadoc);
                        this.myOffset += indentInsideJavadoc.length();
                        docIndentApplied = true;
                    }
                    if (this.myForceIndent && indentInsideJavadoc != null) {
                        int indentSize = CodeStyle.getSettings((PsiFile)this.myFile).getIndentSize(this.myFile.getFileType());
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)StringUtil.repeatSymbol((char)' ', (int)indentSize));
                        this.myCaretAdvance += indentSize;
                    }
                }
                if ((commentContext.docAsterisk || commentContext.docStart) && !docIndentApplied) {
                    char c;
                    if (this.myInsertSpace) {
                        if (this.myOffset == this.myDocument.getTextLength()) {
                            this.myDocument.insertString(this.myOffset, (CharSequence)" ");
                        }
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)" ");
                    }
                    if ((c = this.myDocument.getCharsSequence().charAt(this.myOffset)) != '\n') {
                        ++this.myOffset;
                    }
                }
                if (commentContext.docAsterisk && !commentContext.docStart) {
                    ++this.myCaretAdvance;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            this.myOffset = Math.min(this.myOffset, this.myDocument.getTextLength());
            caretModel.moveToOffset(this.myOffset);
            EditorModificationUtil.scrollToCaret((Editor)this.myEditor);
            this.myEditor.getSelectionModel().removeSelection();
            if (this.myCaretAdvance != 0) {
                LogicalPosition caretPosition = caretModel.getLogicalPosition();
                LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + this.myCaretAdvance);
                caretModel.moveToLogicalPosition(pos);
            }
        }

        private void generateJavadoc(CodeDocumentationAwareCommenter commenter) throws IncorrectOperationException {
            CodeInsightSettings settings = CodeInsightSettings.getInstance();
            StringBuilder buffer = new StringBuilder();
            String docCommentLinePrefix = commenter.getDocumentationCommentLinePrefix();
            if (docCommentLinePrefix == null) {
                return;
            }
            buffer.append(docCommentLinePrefix);
            if (DataManager.getInstance().loadFromDataContext(this.myDataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) == Boolean.TRUE) {
                this.myDocument.insertString(this.myOffset, (CharSequence)buffer);
                buffer = new StringBuilder(LINE_SEPARATOR).append(commenter.getDocumentationCommentSuffix());
                int line = this.myDocument.getLineNumber(this.myOffset);
                this.myOffset = this.myDocument.getLineEndOffset(line);
            } else {
                buffer.append(LINE_SEPARATOR);
                buffer.append(commenter.getDocumentationCommentSuffix());
            }
            PsiComment comment = this.createComment(buffer, settings);
            if (comment == null) {
                return;
            }
            this.myOffset = comment.getTextRange().getStartOffset();
            CharSequence text = this.myDocument.getCharsSequence();
            this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)this.myOffset, (String)LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)this.myOffset, (String)LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)this.myOffset, (String)docCommentLinePrefix) + 1;
            DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
            if (!CodeStyleManager.getInstance((Project)this.getProject()).getDocCommentSettings(this.myFile).isLeadingAsteriskEnabled()) {
                LOG.assertTrue(CharArrayUtil.regionMatches((CharSequence)this.myDocument.getCharsSequence(), (int)(this.myOffset - docCommentLinePrefix.length()), (CharSequence)docCommentLinePrefix));
                this.myDocument.deleteString(this.myOffset - docCommentLinePrefix.length(), this.myOffset);
                --this.myOffset;
            } else {
                this.myDocument.insertString(this.myOffset, (CharSequence)" ");
                ++this.myOffset;
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        }

        @Nullable
        private PsiComment createComment(CharSequence buffer, CodeInsightSettings settings) throws IncorrectOperationException {
            this.myDocument.insertString(this.myOffset, buffer);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(this.myFile, this.myOffset + buffer.length() - 2);
            PsiComment comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            comment = this.createJavaDocStub(settings, comment, this.getProject());
            if (comment == null) {
                return null;
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.getProject());
            Ref commentRef = Ref.create((Object)comment);
            codeStyleManager.runWithDocCommentFormattingDisabled(this.myFile, () -> this.formatComment((Ref<PsiComment>)commentRef, codeStyleManager));
            comment = (PsiComment)commentRef.get();
            PsiElement next = comment.getNextSibling();
            if (next == null && comment.getParent().getClass() == comment.getClass()) {
                next = comment.getParent().getNextSibling();
            }
            if (next != null) {
                next = this.myFile.findElementAt(next.getTextRange().getStartOffset());
            }
            if (!(next == null || FormatterUtil.containsWhiteSpacesOnly(next.getNode()) && next.getText().contains(LINE_SEPARATOR))) {
                int lineBreakOffset = comment.getTextRange().getEndOffset();
                this.myDocument.insertString(lineBreakOffset, (CharSequence)LINE_SEPARATOR);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                codeStyleManager.adjustLineIndent(this.myFile, lineBreakOffset + 1);
                comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            }
            return comment;
        }

        private void formatComment(Ref<PsiComment> commentRef, CodeStyleManager codeStyleManager) {
            PsiComment comment = (PsiComment)commentRef.get();
            RangeMarker commentMarker = this.myDocument.createRangeMarker(comment.getTextRange().getStartOffset(), comment.getTextRange().getEndOffset());
            codeStyleManager.reformatNewlyAddedElement(comment.getNode().getTreeParent(), comment.getNode());
            commentRef.set((Object)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(commentMarker.getStartOffset()), (Class[])new Class[]{PsiComment.class}));
            commentMarker.dispose();
        }

        @Nullable
        private PsiComment createJavaDocStub(CodeInsightSettings settings, PsiComment comment, Project project) {
            if (settings.JAVADOC_STUB_ON_ENTER) {
                CodeDocumentationProvider docProvider;
                DocumentationProvider langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(comment.getParent().getLanguage());
                if (langDocumentationProvider instanceof CompositeDocumentationProvider) {
                    docProvider = ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider();
                } else {
                    CodeDocumentationProvider codeDocumentationProvider = docProvider = langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null;
                }
                if (docProvider != null) {
                    if (docProvider.findExistingDocComment(comment) != comment) {
                        return comment;
                    }
                    String docStub = (String)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> docProvider.generateDocumentationContentStub(comment));
                    if (docStub != null && docStub.length() != 0) {
                        this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
                        this.myOffset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
                        this.myDocument.insertString(this.myOffset, (CharSequence)docStub);
                    }
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                return (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            }
            return comment;
        }

        private Project getProject() {
            return this.myFile.getProject();
        }

        private static void removeTrailingSpaces(Document document, int startOffset) {
            int endOffset = startOffset;
            CharSequence charsSequence = document.getCharsSequence();
            for (int i2 = startOffset; i2 < charsSequence.length(); ++i2) {
                char c = charsSequence.charAt(i2);
                endOffset = i2;
                if (c == '\n') break;
                if (c == ' ' || c == '\t') continue;
                return;
            }
            document.deleteString(startOffset, endOffset);
        }

        private boolean insertDocAsterisk(int lineStart, boolean docAsterisk, boolean previousLineIndentUsed, CodeDocumentationAwareCommenter commenter) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            PsiElement atLineStart = this.myFile.findElementAt(lineStart);
            if (atLineStart == null) {
                return false;
            }
            String linePrefix = commenter.getDocumentationCommentLinePrefix();
            String docPrefix = commenter.getDocumentationCommentPrefix();
            String text = atLineStart.getText();
            TextRange textRange = atLineStart.getTextRange();
            if (text.equals(linePrefix) || text.equals(docPrefix) || docPrefix != null && text.regionMatches(lineStart - textRange.getStartOffset(), docPrefix, 0, docPrefix.length()) || linePrefix != null && text.regionMatches(lineStart - textRange.getStartOffset(), linePrefix, 0, linePrefix.length())) {
                PsiComment comment;
                PsiElement element2 = this.myFile.findElementAt(this.myOffset);
                if (element2 == null) {
                    return false;
                }
                PsiComment psiComment = comment = element2 instanceof PsiComment ? (PsiComment)element2 : (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiComment.class, (boolean)false);
                if (comment != null) {
                    int commentEnd = comment.getTextRange().getEndOffset();
                    if (this.myOffset >= commentEnd || lineStart < comment.getTextOffset()) {
                        docAsterisk = false;
                    } else {
                        DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
                        String toInsert = previousLineIndentUsed ? "*" : CodeDocumentationUtil.createDocCommentLine("", this.myFile, commenter);
                        this.myDocument.insertString(this.myOffset, (CharSequence)toInsert);
                        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                    }
                } else {
                    docAsterisk = false;
                }
            } else {
                docAsterisk = false;
            }
            return docAsterisk;
        }

        public boolean isIndentAdjustmentNeeded() {
            return this.myIsIndentAdjustmentNeeded;
        }
    }
}

