/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderSelectionManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

class DocRenderMouseEventBridge
implements EditorMouseListener,
EditorMouseMotionListener {
    private final DocRenderSelectionManager mySelectionManager;
    private DocRenderer.EditorPane myMouseOverPane;
    private DocRenderer.EditorPane myDragPane;

    DocRenderMouseEventBridge(DocRenderSelectionManager selectionManager) {
        this.mySelectionManager = selectionManager;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        DocRenderer.EditorPane currentPane = DocRenderMouseEventBridge.redispatchEvent(event, 503, null);
        if (currentPane == null) {
            this.restoreCursor();
        } else {
            ((EditorEx)event.getEditor()).setCustomCursor(DocRenderMouseEventBridge.class, currentPane.getCursor());
            if (currentPane != this.myMouseOverPane) {
                if (this.myMouseOverPane != null) {
                    DocRenderMouseEventBridge.dispatchMouseExitEvent(this.myMouseOverPane);
                }
                this.myMouseOverPane = currentPane;
            }
        }
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.checkPaneSelection(DocRenderMouseEventBridge.redispatchEvent(e, 506, this.myDragPane));
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.restoreCursor();
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.myDragPane = DocRenderMouseEventBridge.redispatchEvent(event, 501, null);
        this.checkPaneSelection(this.myDragPane);
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.checkPaneSelection(DocRenderMouseEventBridge.redispatchEvent(event, 502, null));
        this.myDragPane = null;
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        if (event.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        this.checkPaneSelection(DocRenderMouseEventBridge.redispatchEvent(event, 500, null));
    }

    private void restoreCursor() {
        if (this.myMouseOverPane != null) {
            DocRenderMouseEventBridge.dispatchMouseExitEvent(this.myMouseOverPane);
            ((EditorEx)this.myMouseOverPane.getEditor()).setCustomCursor(DocRenderMouseEventBridge.class, null);
            this.myMouseOverPane = null;
        }
    }

    private void checkPaneSelection(@Nullable DocRenderer.EditorPane pane2) {
        if (pane2 != null && pane2.hasSelection()) {
            this.mySelectionManager.setPaneWithSelection(pane2);
        }
    }

    @Nullable
    private static DocRenderer.EditorPane redispatchEvent(@NotNull EditorMouseEvent event, int eventId, @Nullable DocRenderer.EditorPane targetPane) {
        EditorCustomElementRenderer renderer;
        MouseEvent mouseEvent = event.getMouseEvent();
        Point mousePoint = mouseEvent.getPoint();
        Inlay inlay = event.getInlay();
        if (inlay != null && (renderer = inlay.getRenderer()) instanceof DocRenderer) {
            Rectangle relativeBounds = ((DocRenderer)renderer).getEditorPaneBoundsWithinInlay(inlay);
            Rectangle inlayBounds = inlay.getBounds();
            assert (inlayBounds != null);
            int x = mousePoint.x - inlayBounds.x - relativeBounds.x;
            int y = mousePoint.y - inlayBounds.y - relativeBounds.y;
            if (x >= 0 && x < relativeBounds.width && y >= 0 && y < relativeBounds.height) {
                DocRenderer.EditorPane editorPane = ((DocRenderer)renderer).getRendererComponent(inlay, relativeBounds.width);
                if (eventId != 506 || targetPane == editorPane) {
                    int button2 = mouseEvent.getButton();
                    DocRenderMouseEventBridge.dispatchEvent(editorPane, new MouseEvent(editorPane, eventId, 0L, mouseEvent.getModifiersEx(), x, y, mouseEvent.getClickCount(), false, button2 == 2 ? 1 : button2));
                    return editorPane;
                }
            }
        }
        return null;
    }

    private static void dispatchEvent(@NotNull DocRenderer.EditorPane editorPane, @NotNull MouseEvent event) {
        editorPane.doWithRepaintTracking(() -> AWTAccessor.getComponentAccessor().processEvent(editorPane, event));
    }

    private static void dispatchMouseExitEvent(@NotNull DocRenderer.EditorPane editorPane) {
        DocRenderMouseEventBridge.dispatchEvent(editorPane, new MouseEvent(editorPane, 505, 0L, 0, 0, 0, 0, false));
    }
}

