/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Rectangle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockablePopupManager<T extends JComponent> {
    private static final Logger LOG = Logger.getInstance(DockablePopupManager.class);
    protected ToolWindow myToolWindow;
    private Runnable myAutoUpdateRequest;
    @NotNull
    protected final Project myProject;

    public DockablePopupManager(@NotNull Project project) {
        this.myProject = project;
    }

    @Nls
    protected abstract String getShowInToolWindowProperty();

    @Nls
    protected abstract String getAutoUpdateEnabledProperty();

    protected boolean getAutoUpdateDefault() {
        return false;
    }

    @Nls
    protected abstract String getAutoUpdateTitle();

    @Nls
    protected abstract String getRestorePopupDescription();

    @Nls
    protected abstract String getAutoUpdateDescription();

    protected abstract T createComponent();

    protected void doUpdateComponent(@NotNull CompletableFuture<PsiElement> elementFuture, PsiElement originalElement, T component2) {
        try {
            this.doUpdateComponent(elementFuture.get(), originalElement, component2);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Cannot update component", (Throwable)e);
        }
    }

    protected abstract void doUpdateComponent(@NotNull PsiElement var1, PsiElement var2, T var3);

    protected void doUpdateComponent(Editor editor, PsiFile psiFile, boolean requestFocus) {
        this.doUpdateComponent(editor, psiFile);
    }

    protected abstract void doUpdateComponent(Editor var1, PsiFile var2);

    protected abstract void doUpdateComponent(@NotNull PsiElement var1);

    protected abstract String getTitle(PsiElement var1);

    protected abstract String getToolwindowId();

    public Content recreateToolWindow(PsiElement element2, PsiElement originalElement) {
        if (this.myToolWindow == null) {
            this.createToolWindow(element2, originalElement);
            return null;
        }
        Content content2 = this.myToolWindow.getContentManager().getSelectedContent();
        if (content2 == null || !this.myToolWindow.isVisible()) {
            this.restorePopupBehavior();
            this.createToolWindow(element2, originalElement);
            return null;
        }
        return content2;
    }

    public void createToolWindow(@NotNull PsiElement element2, PsiElement originalElement) {
        this.doCreateToolWindow(element2, null, originalElement);
    }

    public void createToolWindow(@NotNull CompletableFuture<PsiElement> elementFuture, PsiElement originalElement) {
        this.doCreateToolWindow(null, elementFuture, originalElement);
    }

    private void doCreateToolWindow(@Nullable PsiElement element2, @Nullable CompletableFuture<PsiElement> elementFuture, PsiElement originalElement) {
        assert (this.myToolWindow == null);
        T component2 = this.createComponent();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolwindowId());
        if (toolWindow == null) {
            toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable((String)this.getToolwindowId(), (Icon)AllIcons.Toolwindows.Documentation, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
        } else {
            toolWindow.setAvailable(true);
        }
        this.myToolWindow = toolWindow;
        toolWindow.setToHideOnEmptyContent(false);
        this.setToolwindowDefaultState();
        ContentManager contentManager2 = toolWindow.getContentManager();
        String displayName = element2 != null ? this.getTitle(element2) : "";
        contentManager2.addContent(ContentFactory.SERVICE.getInstance().createContent(component2, displayName, false));
        contentManager2.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                DockablePopupManager.this.restorePopupBehavior();
            }
        });
        this.installComponentActions(toolWindow, component2);
        new UiNotifyConnector(component2, new Activatable(){

            public void showNotify() {
                DockablePopupManager.this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(DockablePopupManager.this.getAutoUpdateEnabledProperty(), DockablePopupManager.this.getAutoUpdateDefault()));
            }

            public void hideNotify() {
                DockablePopupManager.this.restartAutoUpdate(false);
            }
        });
        this.myToolWindow.show(null);
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.TRUE.toString());
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), true));
        if (element2 != null) {
            this.doUpdateComponent(element2, originalElement, component2);
        } else {
            this.doUpdateComponent(elementFuture, originalElement, component2);
        }
    }

    protected void installComponentActions(@NotNull ToolWindow toolWindow, T component2) {
        ((ToolWindowEx)this.myToolWindow).setAdditionalGearActions((ActionGroup)new DefaultActionGroup(this.createActions()));
    }

    protected void setToolwindowDefaultState() {
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        this.myToolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, rectangle);
    }

    protected AnAction[] createActions() {
        ToggleAction toggleAutoUpdateAction = new ToggleAction(this.getAutoUpdateTitle(), this.getAutoUpdateDescription(), AllIcons.General.AutoscrollFromSource){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return PropertiesComponent.getInstance().getBoolean(DockablePopupManager.this.getAutoUpdateEnabledProperty(), DockablePopupManager.this.getAutoUpdateDefault());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                PropertiesComponent.getInstance().setValue(DockablePopupManager.this.getAutoUpdateEnabledProperty(), state, DockablePopupManager.this.getAutoUpdateDefault());
                DockablePopupManager.this.restartAutoUpdate(state);
            }
        };
        return new AnAction[]{this.createRestorePopupAction(), toggleAutoUpdateAction};
    }

    @NotNull
    protected AnAction createRestorePopupAction() {
        return new DumbAwareAction(CodeInsightBundle.messagePointer((String)"action.AnActionButton.text.open.as.popup", (Object[])new Object[0]), () -> this.getRestorePopupDescription(), null){

            public void actionPerformed(@NotNull AnActionEvent e) {
                DockablePopupManager.this.restorePopupBehavior();
            }
        };
    }

    void restartAutoUpdate(boolean state) {
        if (state && this.myToolWindow != null) {
            if (this.myAutoUpdateRequest == null) {
                this.myAutoUpdateRequest = this::updateComponent;
                UIUtil.invokeLaterIfNeeded(() -> IdeEventQueue.getInstance().addIdleListener(this.myAutoUpdateRequest, 500));
            }
        } else if (this.myAutoUpdateRequest != null) {
            IdeEventQueue.getInstance().removeIdleListener(this.myAutoUpdateRequest);
            this.myAutoUpdateRequest = null;
        }
    }

    public void resetAutoUpdateState() {
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), this.getAutoUpdateDefault()));
    }

    public void updateComponent() {
        this.updateComponent(false);
    }

    public void updateComponent(boolean requestFocus) {
        if (this.myProject.isDisposed()) {
            return;
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
            if (!this.myProject.isOpen()) {
                return;
            }
            this.updateComponentInner((DataContext)dataContext, requestFocus);
        });
    }

    private void updateComponentInner(@NotNull DataContext dataContext, boolean requestFocus) {
        if (CommonDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element2 != null) {
                this.doUpdateComponent(element2);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
            if (editor.isDisposed()) {
                return;
            }
            PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2);
            PsiFile injectedFile = PsiUtilBase.getPsiFileInEditor((Editor)injectedEditor, (Project)this.myProject);
            if (injectedFile != null) {
                this.doUpdateComponent(injectedEditor, injectedFile, requestFocus);
            } else if (file2 != null) {
                this.doUpdateComponent(editor, file2, requestFocus);
            }
        });
    }

    public void restorePopupBehavior() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            return;
        }
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.FALSE.toString());
        toolWindow.remove();
        Disposer.dispose((Disposable)toolWindow.getContentManager());
        this.myToolWindow = null;
        this.restartAutoUpdate(false);
    }

    public boolean hasActiveDockedDocWindow() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }
}

