/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoHolder {
    private final PsiFile myContextFile;
    private final HighlightInfoFilter[] myFilters;
    private final AnnotationSession myAnnotationSession;
    private int myErrorCount;
    private final List<HighlightInfo> myInfos = new ArrayList<HighlightInfo>(5);

    public HighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters) {
        this.myContextFile = contextFile;
        this.myAnnotationSession = new AnnotationSession(contextFile);
        this.myFilters = filters;
    }

    @NotNull
    public AnnotationSession getAnnotationSession() {
        return this.myAnnotationSession;
    }

    public boolean add(@Nullable HighlightInfo info) {
        if (info == null || !this.accepted(info)) {
            return false;
        }
        HighlightSeverity severity = info.getSeverity();
        if (severity == HighlightSeverity.ERROR) {
            ++this.myErrorCount;
        }
        return this.myInfos.add(info);
    }

    public void clear() {
        this.myErrorCount = 0;
        this.myInfos.clear();
    }

    public boolean hasErrorResults() {
        return this.myErrorCount != 0;
    }

    public boolean addAll(@NotNull Collection<? extends HighlightInfo> highlightInfos) {
        boolean added = false;
        for (HighlightInfo highlightInfo : highlightInfos) {
            added |= this.add(highlightInfo);
        }
        return added;
    }

    public int size() {
        return this.myInfos.size();
    }

    @NotNull
    public HighlightInfo get(int i2) {
        return this.myInfos.get(i2);
    }

    @NotNull
    public Project getProject() {
        return this.myContextFile.getProject();
    }

    @NotNull
    public PsiFile getContextFile() {
        return this.myContextFile;
    }

    private boolean accepted(@NotNull HighlightInfo info) {
        for (HighlightInfoFilter filter2 : this.myFilters) {
            if (filter2.accept(info, this.getContextFile())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextAttributesScheme getColorsScheme() {
        return key -> key.getDefaultAttributes();
    }

    @ApiStatus.Internal
    public void queueToUpdateIncrementally() {
    }
}

