/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntentionsUI {
    private final Project myProject;
    private final AtomicReference<CachedIntentions> myCachedIntentions = new AtomicReference();

    public static IntentionsUI getInstance(Project project) {
        return (IntentionsUI)ServiceManager.getService((Project)project, IntentionsUI.class);
    }

    public IntentionsUI(Project project) {
        this.myProject = project;
    }

    @NotNull
    public CachedIntentions getCachedIntentions(@Nullable Editor editor, @NotNull PsiFile file2) {
        return this.myCachedIntentions.updateAndGet(cachedIntentions -> {
            if (cachedIntentions != null && editor == cachedIntentions.getEditor() && file2 == cachedIntentions.getFile()) {
                return cachedIntentions;
            }
            return new CachedIntentions(this.myProject, file2, editor);
        });
    }

    public void invalidate() {
        this.myCachedIntentions.set(null);
        this.hide();
    }

    public abstract void update(@NotNull CachedIntentions var1, boolean var2);

    public abstract void hide();
}

